/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.summer.context;

import com.itranswarp.summer.annotation.Autowired;
import com.itranswarp.summer.annotation.Bean;
import com.itranswarp.summer.annotation.Component;
import com.itranswarp.summer.annotation.ComponentScan;
import com.itranswarp.summer.annotation.Configuration;
import com.itranswarp.summer.annotation.Import;
import com.itranswarp.summer.annotation.Order;
import com.itranswarp.summer.annotation.Primary;
import com.itranswarp.summer.annotation.Value;
import com.itranswarp.summer.context.ApplicationContextUtils;
import com.itranswarp.summer.context.BeanDefinition;
import com.itranswarp.summer.context.BeanPostProcessor;
import com.itranswarp.summer.context.ConfigurableApplicationContext;
import com.itranswarp.summer.exception.BeanCreationException;
import com.itranswarp.summer.exception.BeanDefinitionException;
import com.itranswarp.summer.exception.BeanNotOfRequiredTypeException;
import com.itranswarp.summer.exception.NoSuchBeanDefinitionException;
import com.itranswarp.summer.exception.NoUniqueBeanDefinitionException;
import com.itranswarp.summer.exception.UnsatisfiedDependencyException;
import com.itranswarp.summer.io.PropertyResolver;
import com.itranswarp.summer.io.ResourceResolver;
import com.itranswarp.summer.utils.ClassUtils;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationConfigApplicationContext
implements ConfigurableApplicationContext {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final PropertyResolver propertyResolver;
    protected final Map<String, BeanDefinition> beans;
    private List<BeanPostProcessor> beanPostProcessors = new ArrayList<BeanPostProcessor>();
    private Set<String> creatingBeanNames;

    public AnnotationConfigApplicationContext(Class<?> configClass, PropertyResolver propertyResolver) {
        ApplicationContextUtils.setApplicationContext(this);
        this.propertyResolver = propertyResolver;
        Set<String> beanClassNames = this.scanForClassNames(configClass);
        this.beans = this.createBeanDefinitions(beanClassNames);
        this.creatingBeanNames = new HashSet<String>();
        this.beans.values().stream().filter(this::isConfigurationDefinition).sorted().map(def -> {
            this.createBeanAsEarlySingleton((BeanDefinition)def);
            return def.getName();
        }).collect(Collectors.toList());
        List processors = this.beans.values().stream().filter(this::isBeanPostProcessorDefinition).sorted().map(def -> (BeanPostProcessor)this.createBeanAsEarlySingleton((BeanDefinition)def)).collect(Collectors.toList());
        this.beanPostProcessors.addAll(processors);
        this.createNormalBeans();
        this.beans.values().forEach(def -> this.injectBean((BeanDefinition)def));
        this.beans.values().forEach(def -> this.initBean((BeanDefinition)def));
        if (this.logger.isDebugEnabled()) {
            this.beans.values().stream().sorted().forEach(def -> this.logger.debug("bean initialized: {}", def));
        }
    }

    void createNormalBeans() {
        List<BeanDefinition> defs = this.beans.values().stream().filter(def -> def.getInstance() == null).sorted().collect(Collectors.toList());
        defs.forEach(def -> {
            if (def.getInstance() == null) {
                this.createBeanAsEarlySingleton((BeanDefinition)def);
            }
        });
    }

    @Override
    public Object createBeanAsEarlySingleton(BeanDefinition def) {
        this.logger.atDebug().log("Try create bean '{}' as early singleton: {}", (Object)def.getName(), (Object)def.getBeanClass().getName());
        if (!this.creatingBeanNames.add(def.getName())) {
            throw new UnsatisfiedDependencyException(String.format("Circular dependency detected when create bean '%s'", def.getName()));
        }
        Executable createFn = null;
        createFn = def.getFactoryName() == null ? def.getConstructor() : def.getFactoryMethod();
        Parameter[] parameters = createFn.getParameters();
        Annotation[][] parametersAnnos = createFn.getParameterAnnotations();
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            BeanDefinition dependsOnDef;
            Parameter param = parameters[i];
            Annotation[] paramAnnos = parametersAnnos[i];
            Value value = ClassUtils.getAnnotation(paramAnnos, Value.class);
            Autowired autowired = ClassUtils.getAnnotation(paramAnnos, Autowired.class);
            boolean isConfiguration = this.isConfigurationDefinition(def);
            if (isConfiguration && autowired != null) {
                throw new BeanCreationException(String.format("Cannot specify @Autowired when create @Configuration bean '%s': %s.", def.getName(), def.getBeanClass().getName()));
            }
            boolean isBeanPostProcessor = this.isBeanPostProcessorDefinition(def);
            if (isBeanPostProcessor && autowired != null) {
                throw new BeanCreationException(String.format("Cannot specify @Autowired when create BeanPostProcessor '%s': %s.", def.getName(), def.getBeanClass().getName()));
            }
            if (value != null && autowired != null) {
                throw new BeanCreationException(String.format("Cannot specify both @Autowired and @Value when create bean '%s': %s.", def.getName(), def.getBeanClass().getName()));
            }
            if (value == null && autowired == null) {
                throw new BeanCreationException(String.format("Must specify @Autowired or @Value when create bean '%s': %s.", def.getName(), def.getBeanClass().getName()));
            }
            Class<?> type = param.getType();
            if (value != null) {
                args[i] = this.propertyResolver.getRequiredProperty(value.value(), type);
                continue;
            }
            String name = autowired.name();
            boolean required = autowired.value();
            BeanDefinition beanDefinition = dependsOnDef = name.isEmpty() ? this.findBeanDefinition(type) : this.findBeanDefinition(name, type);
            if (required && dependsOnDef == null) {
                throw new BeanCreationException(String.format("Missing autowired bean with type '%s' when create bean '%s': %s.", type.getName(), def.getName(), def.getBeanClass().getName()));
            }
            if (dependsOnDef != null) {
                Object autowiredBeanInstance = dependsOnDef.getInstance();
                if (autowiredBeanInstance == null && !isConfiguration && !isBeanPostProcessor) {
                    autowiredBeanInstance = this.createBeanAsEarlySingleton(dependsOnDef);
                }
                args[i] = autowiredBeanInstance;
                continue;
            }
            args[i] = null;
        }
        Object instance = null;
        if (def.getFactoryName() == null) {
            try {
                instance = def.getConstructor().newInstance(args);
            }
            catch (Exception e) {
                throw new BeanCreationException(String.format("Exception when create bean '%s': %s", def.getName(), def.getBeanClass().getName()), e);
            }
        }
        Object configInstance = this.getBean(def.getFactoryName());
        try {
            instance = def.getFactoryMethod().invoke(configInstance, args);
        }
        catch (Exception e) {
            throw new BeanCreationException(String.format("Exception when create bean '%s': %s", def.getName(), def.getBeanClass().getName()), e);
        }
        def.setInstance(instance);
        for (BeanPostProcessor processor : this.beanPostProcessors) {
            Object processed = processor.postProcessBeforeInitialization(def.getInstance(), def.getName());
            if (processed == null) {
                throw new BeanCreationException(String.format("PostBeanProcessor returns null when process bean '%s' by %s", def.getName(), processor));
            }
            if (def.getInstance() == processed) continue;
            this.logger.atDebug().log("Bean '{}' was replaced by post processor {}.", (Object)def.getName(), (Object)processor.getClass().getName());
            def.setInstance(processed);
        }
        return def.getInstance();
    }

    Map<String, BeanDefinition> createBeanDefinitions(Set<String> classNameSet) {
        HashMap<String, BeanDefinition> defs = new HashMap<String, BeanDefinition>();
        for (String className : classNameSet) {
            Component component;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new BeanCreationException(e);
            }
            if (clazz.isAnnotation() || clazz.isEnum() || clazz.isInterface() || clazz.isRecord() || (component = ClassUtils.findAnnotation(clazz, Component.class)) == null) continue;
            this.logger.atDebug().log("found component: {}", (Object)clazz.getName());
            int mod = clazz.getModifiers();
            if (Modifier.isAbstract(mod)) {
                throw new BeanDefinitionException("@Component class " + clazz.getName() + " must not be abstract.");
            }
            if (Modifier.isPrivate(mod)) {
                throw new BeanDefinitionException("@Component class " + clazz.getName() + " must not be private.");
            }
            String beanName = ClassUtils.getBeanName(clazz);
            BeanDefinition def = new BeanDefinition(beanName, clazz, this.getSuitableConstructor(clazz), this.getOrder(clazz), clazz.isAnnotationPresent(Primary.class), null, null, ClassUtils.findAnnotationMethod(clazz, PostConstruct.class), ClassUtils.findAnnotationMethod(clazz, PreDestroy.class));
            this.addBeanDefinitions(defs, def);
            this.logger.atDebug().log("define bean: {}", (Object)def);
            Configuration configuration = ClassUtils.findAnnotation(clazz, Configuration.class);
            if (configuration == null) continue;
            if (BeanPostProcessor.class.isAssignableFrom(clazz)) {
                throw new BeanDefinitionException("@Configuration class '" + clazz.getName() + "' cannot be BeanPostProcessor.");
            }
            this.scanFactoryMethods(beanName, clazz, defs);
        }
        return defs;
    }

    void injectBean(BeanDefinition def) {
        Object beanInstance = this.getProxiedInstance(def);
        try {
            this.injectProperties(def, def.getBeanClass(), beanInstance);
        }
        catch (ReflectiveOperationException e) {
            throw new BeanCreationException(e);
        }
    }

    void initBean(BeanDefinition def) {
        Object beanInstance = this.getProxiedInstance(def);
        this.callMethod(beanInstance, def.getInitMethod(), def.getInitMethodName());
        this.beanPostProcessors.forEach(beanPostProcessor -> {
            Object processedInstance = beanPostProcessor.postProcessAfterInitialization(def.getInstance(), def.getName());
            if (processedInstance != def.getInstance()) {
                this.logger.atDebug().log("BeanPostProcessor {} return different bean from {} to {}.", new Object[]{beanPostProcessor.getClass().getSimpleName(), def.getInstance().getClass().getName(), processedInstance.getClass().getName()});
                def.setInstance(processedInstance);
            }
        });
    }

    void injectProperties(BeanDefinition def, Class<?> clazz, Object bean) throws ReflectiveOperationException {
        for (Field field : clazz.getDeclaredFields()) {
            this.tryInjectProperties(def, clazz, bean, field);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            this.tryInjectProperties(def, clazz, bean, accessibleObject);
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            this.injectProperties(def, superClazz, bean);
        }
    }

    void tryInjectProperties(BeanDefinition def, Class<?> clazz, Object bean, AccessibleObject acc) throws ReflectiveOperationException {
        Class<?> accessibleType;
        Value value = acc.getAnnotation(Value.class);
        Autowired autowired = acc.getAnnotation(Autowired.class);
        if (value == null && autowired == null) {
            return;
        }
        Field field = null;
        Method method = null;
        if (acc instanceof Field) {
            Field f = (Field)acc;
            this.checkFieldOrMethod(f);
            f.setAccessible(true);
            field = f;
        }
        if (acc instanceof Method) {
            Method m = (Method)acc;
            this.checkFieldOrMethod(m);
            if (m.getParameters().length != 1) {
                throw new BeanDefinitionException(String.format("Cannot inject a non-setter method %s for bean '%s': %s", m.getName(), def.getName(), def.getBeanClass().getName()));
            }
            m.setAccessible(true);
            method = m;
        }
        String accessibleName = field != null ? field.getName() : method.getName();
        Class<?> clazz2 = accessibleType = field != null ? field.getType() : method.getParameterTypes()[0];
        if (value != null && autowired != null) {
            throw new BeanCreationException(String.format("Cannot specify both @Autowired and @Value when inject %s.%s for bean '%s': %s", clazz.getSimpleName(), accessibleName, def.getName(), def.getBeanClass().getName()));
        }
        if (value != null) {
            Object propValue = this.propertyResolver.getRequiredProperty(value.value(), accessibleType);
            if (field != null) {
                this.logger.atDebug().log("Field injection: {}.{} = {}", new Object[]{def.getBeanClass().getName(), accessibleName, propValue});
                field.set(bean, propValue);
            }
            if (method != null) {
                this.logger.atDebug().log("Method injection: {}.{} ({})", new Object[]{def.getBeanClass().getName(), accessibleName, propValue});
                method.invoke(bean, propValue);
            }
        }
        if (autowired != null) {
            Object depends;
            String name = autowired.name();
            boolean required = autowired.value();
            Object obj = depends = name.isEmpty() ? this.findBean(accessibleType) : this.findBean(name, accessibleType);
            if (required && depends == null) {
                throw new UnsatisfiedDependencyException(String.format("Dependency bean not found when inject %s.%s for bean '%s': %s", clazz.getSimpleName(), accessibleName, def.getName(), def.getBeanClass().getName()));
            }
            if (depends != null) {
                if (field != null) {
                    this.logger.atDebug().log("Field injection: {}.{} = {}", new Object[]{def.getBeanClass().getName(), accessibleName, depends});
                    field.set(bean, depends);
                }
                if (method != null) {
                    this.logger.atDebug().log("Mield injection: {}.{} ({})", new Object[]{def.getBeanClass().getName(), accessibleName, depends});
                    method.invoke(bean, depends);
                }
            }
        }
    }

    void checkFieldOrMethod(Member m) {
        int mod = m.getModifiers();
        if (Modifier.isStatic(mod)) {
            throw new BeanDefinitionException("Cannot inject static field: " + String.valueOf(m));
        }
        if (Modifier.isFinal(mod)) {
            if (m instanceof Field) {
                Field field = (Field)m;
                throw new BeanDefinitionException("Cannot inject final field: " + String.valueOf(field));
            }
            if (m instanceof Method) {
                Method method = (Method)m;
                this.logger.warn("Inject final method should be careful because it is not called on target bean when bean is proxied and may cause NullPointerException.");
            }
        }
    }

    Constructor<?> getSuitableConstructor(Class<?> clazz) {
        Constructor<?>[] cons = clazz.getConstructors();
        if (cons.length == 0 && (cons = clazz.getDeclaredConstructors()).length != 1) {
            throw new BeanDefinitionException("More than one constructor found in class " + clazz.getName() + ".");
        }
        if (cons.length != 1) {
            throw new BeanDefinitionException("More than one public constructor found in class " + clazz.getName() + ".");
        }
        return cons[0];
    }

    void scanFactoryMethods(String factoryBeanName, Class<?> clazz, Map<String, BeanDefinition> defs) {
        for (Method method : clazz.getDeclaredMethods()) {
            Bean bean = method.getAnnotation(Bean.class);
            if (bean == null) continue;
            int mod = method.getModifiers();
            if (Modifier.isAbstract(mod)) {
                throw new BeanDefinitionException("@Bean method " + clazz.getName() + "." + method.getName() + " must not be abstract.");
            }
            if (Modifier.isFinal(mod)) {
                throw new BeanDefinitionException("@Bean method " + clazz.getName() + "." + method.getName() + " must not be final.");
            }
            if (Modifier.isPrivate(mod)) {
                throw new BeanDefinitionException("@Bean method " + clazz.getName() + "." + method.getName() + " must not be private.");
            }
            Class<?> beanClass = method.getReturnType();
            if (beanClass.isPrimitive()) {
                throw new BeanDefinitionException("@Bean method " + clazz.getName() + "." + method.getName() + " must not return primitive type.");
            }
            if (beanClass == Void.TYPE || beanClass == Void.class) {
                throw new BeanDefinitionException("@Bean method " + clazz.getName() + "." + method.getName() + " must not return void.");
            }
            BeanDefinition def = new BeanDefinition(ClassUtils.getBeanName(method), beanClass, factoryBeanName, method, this.getOrder(method), method.isAnnotationPresent(Primary.class), bean.initMethod().isEmpty() ? null : bean.initMethod(), bean.destroyMethod().isEmpty() ? null : bean.destroyMethod(), null, null);
            this.addBeanDefinitions(defs, def);
            this.logger.atDebug().log("define bean: {}", (Object)def);
        }
    }

    void addBeanDefinitions(Map<String, BeanDefinition> defs, BeanDefinition def) {
        if (defs.put(def.getName(), def) != null) {
            throw new BeanDefinitionException("Duplicate bean name: " + def.getName());
        }
    }

    int getOrder(Class<?> clazz) {
        Order order = clazz.getAnnotation(Order.class);
        return order == null ? Integer.MAX_VALUE : order.value();
    }

    int getOrder(Method method) {
        Order order = method.getAnnotation(Order.class);
        return order == null ? Integer.MAX_VALUE : order.value();
    }

    protected Set<String> scanForClassNames(Class<?> configClass) {
        Object[] objectArray;
        ComponentScan scan = ClassUtils.findAnnotation(configClass, ComponentScan.class);
        if (scan == null || scan.value().length == 0) {
            Object[] objectArray2 = new String[1];
            objectArray = objectArray2;
            objectArray2[0] = configClass.getPackage().getName();
        } else {
            objectArray = scan.value();
        }
        Object[] scanPackages = objectArray;
        this.logger.atInfo().log("component scan in packages: {}", (Object)Arrays.toString(scanPackages));
        HashSet<String> classNameSet = new HashSet<String>();
        for (Object pkg : scanPackages) {
            this.logger.atDebug().log("scan package: {}", pkg);
            ResourceResolver rr = new ResourceResolver((String)pkg);
            List<String> classList = rr.scan(res -> {
                String name = res.name();
                if (name.endsWith(".class")) {
                    return name.substring(0, name.length() - 6).replace("/", ".").replace("\\", ".");
                }
                return null;
            });
            if (this.logger.isDebugEnabled()) {
                classList.forEach(className -> this.logger.debug("class found by component scan: {}", className));
            }
            classNameSet.addAll(classList);
        }
        Import importConfig = configClass.getAnnotation(Import.class);
        if (importConfig != null) {
            for (Class<?> importConfigClass : importConfig.value()) {
                String importClassName = importConfigClass.getName();
                if (classNameSet.contains(importClassName)) {
                    this.logger.warn("ignore import: " + importClassName + " for it is already been scanned.");
                    continue;
                }
                this.logger.debug("class found by import: {}", (Object)importClassName);
                classNameSet.add(importClassName);
            }
        }
        return classNameSet;
    }

    boolean isConfigurationDefinition(BeanDefinition def) {
        return ClassUtils.findAnnotation(def.getBeanClass(), Configuration.class) != null;
    }

    boolean isBeanPostProcessorDefinition(BeanDefinition def) {
        return BeanPostProcessor.class.isAssignableFrom(def.getBeanClass());
    }

    @Override
    @Nullable
    public BeanDefinition findBeanDefinition(String name) {
        return this.beans.get(name);
    }

    @Override
    @Nullable
    public BeanDefinition findBeanDefinition(String name, Class<?> requiredType) {
        BeanDefinition def = this.findBeanDefinition(name);
        if (def == null) {
            return null;
        }
        if (!requiredType.isAssignableFrom(def.getBeanClass())) {
            throw new BeanNotOfRequiredTypeException(String.format("Autowire required type '%s' but bean '%s' has actual type '%s'.", requiredType.getName(), name, def.getBeanClass().getName()));
        }
        return def;
    }

    @Override
    public List<BeanDefinition> findBeanDefinitions(Class<?> type) {
        return this.beans.values().stream().filter(def -> type.isAssignableFrom(def.getBeanClass())).sorted().collect(Collectors.toList());
    }

    @Override
    @Nullable
    public BeanDefinition findBeanDefinition(Class<?> type) {
        List<BeanDefinition> defs = this.findBeanDefinitions(type);
        if (defs.isEmpty()) {
            return null;
        }
        if (defs.size() == 1) {
            return defs.get(0);
        }
        List primaryDefs = defs.stream().filter(def -> def.isPrimary()).collect(Collectors.toList());
        if (primaryDefs.size() == 1) {
            return (BeanDefinition)primaryDefs.get(0);
        }
        if (primaryDefs.isEmpty()) {
            throw new NoUniqueBeanDefinitionException(String.format("Multiple bean with type '%s' found, but no @Primary specified.", type.getName()));
        }
        throw new NoUniqueBeanDefinitionException(String.format("Multiple bean with type '%s' found, and multiple @Primary specified.", type.getName()));
    }

    @Override
    public <T> T getBean(String name) {
        BeanDefinition def = this.beans.get(name);
        if (def == null) {
            throw new NoSuchBeanDefinitionException(String.format("No bean defined with name '%s'.", name));
        }
        return (T)def.getRequiredInstance();
    }

    @Override
    public <T> T getBean(String name, Class<T> requiredType) {
        T t = this.findBean(name, requiredType);
        if (t == null) {
            throw new NoSuchBeanDefinitionException(String.format("No bean defined with name '%s' and type '%s'.", name, requiredType));
        }
        return t;
    }

    @Override
    public <T> List<T> getBeans(Class<T> requiredType) {
        List<BeanDefinition> defs = this.findBeanDefinitions(requiredType);
        if (defs.isEmpty()) {
            return List.of();
        }
        ArrayList<Object> list = new ArrayList<Object>(defs.size());
        for (BeanDefinition def : defs) {
            list.add(def.getRequiredInstance());
        }
        return list;
    }

    @Override
    public <T> T getBean(Class<T> requiredType) {
        BeanDefinition def = this.findBeanDefinition(requiredType);
        if (def == null) {
            throw new NoSuchBeanDefinitionException(String.format("No bean defined with type '%s'.", requiredType));
        }
        return (T)def.getRequiredInstance();
    }

    @Override
    public boolean containsBean(String name) {
        return this.beans.containsKey(name);
    }

    @Nullable
    protected <T> T findBean(String name, Class<T> requiredType) {
        BeanDefinition def = this.findBeanDefinition(name, requiredType);
        if (def == null) {
            return null;
        }
        return (T)def.getRequiredInstance();
    }

    @Nullable
    protected <T> T findBean(Class<T> requiredType) {
        BeanDefinition def = this.findBeanDefinition(requiredType);
        if (def == null) {
            return null;
        }
        return (T)def.getRequiredInstance();
    }

    @Nullable
    protected <T> List<T> findBeans(Class<T> requiredType) {
        return this.findBeanDefinitions(requiredType).stream().map(def -> def.getRequiredInstance()).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.logger.info("Closing {}...", (Object)this.getClass().getName());
        this.beans.values().forEach(def -> {
            Object beanInstance = this.getProxiedInstance((BeanDefinition)def);
            this.callMethod(beanInstance, def.getDestroyMethod(), def.getDestroyMethodName());
        });
        this.beans.clear();
        this.logger.info("{} closed.", (Object)this.getClass().getName());
        ApplicationContextUtils.setApplicationContext(null);
    }

    private Object getProxiedInstance(BeanDefinition def) {
        Object beanInstance = def.getInstance();
        ArrayList<BeanPostProcessor> reversedBeanPostProcessors = new ArrayList<BeanPostProcessor>(this.beanPostProcessors);
        Collections.reverse(reversedBeanPostProcessors);
        for (BeanPostProcessor beanPostProcessor : reversedBeanPostProcessors) {
            Object restoredInstance = beanPostProcessor.postProcessOnSetProperty(beanInstance, def.getName());
            if (restoredInstance == beanInstance) continue;
            this.logger.atDebug().log("BeanPostProcessor {} specified injection from {} to {}.", new Object[]{beanPostProcessor.getClass().getSimpleName(), beanInstance.getClass().getSimpleName(), restoredInstance.getClass().getSimpleName()});
            beanInstance = restoredInstance;
        }
        return beanInstance;
    }

    private void callMethod(Object beanInstance, Method method, String namedMethod) {
        if (method != null) {
            try {
                method.invoke(beanInstance, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new BeanCreationException(e);
            }
        }
        if (namedMethod != null) {
            Method named = ClassUtils.getNamedMethod(beanInstance.getClass(), namedMethod);
            named.setAccessible(true);
            try {
                named.invoke(beanInstance, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new BeanCreationException(e);
            }
        }
    }
}

