/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.summer.io;

import com.itranswarp.summer.io.PropertyExpr;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyResolver {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    Map<String, String> properties = new HashMap<String, String>();
    Map<Class<?>, Function<String, Object>> converters = new HashMap();

    public PropertyResolver(Properties props) {
        this.properties.putAll(System.getenv());
        Set<String> names = props.stringPropertyNames();
        for (String name : names) {
            this.properties.put(name, props.getProperty(name));
        }
        if (this.logger.isDebugEnabled()) {
            ArrayList<String> keys = new ArrayList<String>(this.properties.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                this.logger.debug("PropertyResolver: {} = {}", (Object)key, (Object)this.properties.get(key));
            }
        }
        this.converters.put(String.class, s -> s);
        this.converters.put(Boolean.TYPE, s -> Boolean.parseBoolean(s));
        this.converters.put(Boolean.class, s -> Boolean.valueOf(s));
        this.converters.put(Byte.TYPE, s -> Byte.parseByte(s));
        this.converters.put(Byte.class, s -> Byte.valueOf(s));
        this.converters.put(Short.TYPE, s -> Short.parseShort(s));
        this.converters.put(Short.class, s -> Short.valueOf(s));
        this.converters.put(Integer.TYPE, s -> Integer.parseInt(s));
        this.converters.put(Integer.class, s -> Integer.valueOf(s));
        this.converters.put(Long.TYPE, s -> Long.parseLong(s));
        this.converters.put(Long.class, s -> Long.valueOf(s));
        this.converters.put(Float.TYPE, s -> Float.valueOf(Float.parseFloat(s)));
        this.converters.put(Float.class, s -> Float.valueOf(s));
        this.converters.put(Double.TYPE, s -> Double.parseDouble(s));
        this.converters.put(Double.class, s -> Double.valueOf(s));
        this.converters.put(LocalDate.class, s -> LocalDate.parse(s));
        this.converters.put(LocalTime.class, s -> LocalTime.parse(s));
        this.converters.put(LocalDateTime.class, s -> LocalDateTime.parse(s));
        this.converters.put(ZonedDateTime.class, s -> ZonedDateTime.parse(s));
        this.converters.put(Duration.class, s -> Duration.parse(s));
        this.converters.put(ZoneId.class, s -> ZoneId.of(s));
    }

    public boolean containsProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Nullable
    public String getProperty(String key) {
        PropertyExpr keyExpr = this.parsePropertyExpr(key);
        if (keyExpr != null) {
            if (keyExpr.defaultValue() != null) {
                return this.getProperty(keyExpr.key(), keyExpr.defaultValue());
            }
            return this.getRequiredProperty(keyExpr.key());
        }
        String value = this.properties.get(key);
        if (value != null) {
            return this.parseValue(value);
        }
        return value;
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value == null ? this.parseValue(defaultValue) : value;
    }

    @Nullable
    public <T> T getProperty(String key, Class<T> targetType) {
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        return this.convert(targetType, value);
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return this.convert(targetType, value);
    }

    public String getRequiredProperty(String key) {
        String value = this.getProperty(key);
        return Objects.requireNonNull(value, "Property '" + key + "' not found.");
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) {
        T value = this.getProperty(key, targetType);
        return Objects.requireNonNull(value, "Property '" + key + "' not found.");
    }

    <T> T convert(Class<?> clazz, String value) {
        Function<String, Object> fn = this.converters.get(clazz);
        if (fn == null) {
            throw new IllegalArgumentException("Unsupported value type: " + clazz.getName());
        }
        return (T)fn.apply(value);
    }

    String parseValue(String value) {
        PropertyExpr expr = this.parsePropertyExpr(value);
        if (expr == null) {
            return value;
        }
        if (expr.defaultValue() != null) {
            return this.getProperty(expr.key(), expr.defaultValue());
        }
        return this.getRequiredProperty(expr.key());
    }

    PropertyExpr parsePropertyExpr(String key) {
        if (key.startsWith("${") && key.endsWith("}")) {
            int n = key.indexOf(58);
            if (n == -1) {
                String k = this.notEmpty(key.substring(2, key.length() - 1));
                return new PropertyExpr(k, null);
            }
            String k = this.notEmpty(key.substring(2, n));
            return new PropertyExpr(k, key.substring(n + 1, key.length() - 1));
        }
        return null;
    }

    String notEmpty(String key) {
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Invalid key: " + key);
        }
        return key;
    }
}

