/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.summer.utils;

import com.itranswarp.summer.annotation.Bean;
import com.itranswarp.summer.annotation.Component;
import com.itranswarp.summer.exception.BeanDefinitionException;
import jakarta.annotation.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ClassUtils {
    public static <A extends Annotation> A findAnnotation(Class<?> target, Class<A> annoClass) {
        A a = target.getAnnotation(annoClass);
        for (Annotation anno : target.getAnnotations()) {
            A found;
            Class<? extends Annotation> annoType = anno.annotationType();
            if (annoType.getPackageName().equals("java.lang.annotation") || (found = ClassUtils.findAnnotation(annoType, annoClass)) == null) continue;
            if (a != null) {
                throw new BeanDefinitionException("Duplicate @" + annoClass.getSimpleName() + " found on class " + target.getSimpleName());
            }
            a = found;
        }
        return a;
    }

    @Nullable
    public static <A extends Annotation> A getAnnotation(Annotation[] annos, Class<A> annoClass) {
        for (Annotation anno : annos) {
            if (!annoClass.isInstance(anno)) continue;
            return (A)anno;
        }
        return null;
    }

    public static String getBeanName(Method method) {
        Bean bean = method.getAnnotation(Bean.class);
        String name = bean.value();
        if (name.isEmpty()) {
            name = method.getName();
        }
        return name;
    }

    public static String getBeanName(Class<?> clazz) {
        Object name = "";
        Component component = clazz.getAnnotation(Component.class);
        if (component != null) {
            name = component.value();
        } else {
            for (Annotation anno : clazz.getAnnotations()) {
                if (ClassUtils.findAnnotation(anno.annotationType(), Component.class) == null) continue;
                try {
                    name = (String)anno.annotationType().getMethod("value", new Class[0]).invoke((Object)anno, new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new BeanDefinitionException("Cannot get annotation value.", e);
                }
            }
        }
        if (((String)name).isEmpty()) {
            name = clazz.getSimpleName();
            name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
        }
        return name;
    }

    @Nullable
    public static Method findAnnotationMethod(Class<?> clazz, Class<? extends Annotation> annoClass) {
        List ms = Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(annoClass)).map(m -> {
            if (m.getParameterCount() != 0) {
                throw new BeanDefinitionException(String.format("Method '%s' with @%s must not have argument: %s", m.getName(), annoClass.getSimpleName(), clazz.getName()));
            }
            return m;
        }).collect(Collectors.toList());
        if (ms.isEmpty()) {
            return null;
        }
        if (ms.size() == 1) {
            return (Method)ms.get(0);
        }
        throw new BeanDefinitionException(String.format("Multiple methods with @%s found in class: %s", annoClass.getSimpleName(), clazz.getName()));
    }

    public static Method getNamedMethod(Class<?> clazz, String methodName) {
        try {
            return clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new BeanDefinitionException(String.format("Method '%s' not found in class: %s", methodName, clazz.getName()));
        }
    }
}

