/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.ObjectUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.List;

public class OperatorQueryCondition
extends QueryCondition {
    private final String operator;
    private QueryCondition childCondition;

    public OperatorQueryCondition(String operator, QueryCondition childCondition) {
        this.operator = operator;
        this.childCondition = childCondition;
    }

    @Override
    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        String childSql;
        StringBuilder sql = new StringBuilder();
        if (this.checkEffective() && StringUtil.isNotBlank(childSql = this.childCondition.toSql(queryTables, dialect))) {
            QueryCondition prevEffectiveCondition = this.getPrevEffectiveCondition();
            if (prevEffectiveCondition != null) {
                sql.append((Object)prevEffectiveCondition.connector);
            }
            sql.append(this.operator).append("(").append(childSql).append(")");
        }
        if (this.next != null) {
            return sql + this.next.toSql(queryTables, dialect);
        }
        return sql.toString();
    }

    @Override
    public Object getValue() {
        return WrapperUtil.getValues(this.childCondition);
    }

    @Override
    boolean containsTable(String ... tables) {
        return this.childCondition != null && this.childCondition.containsTable(tables);
    }

    @Override
    public OperatorQueryCondition clone() {
        OperatorQueryCondition clone = (OperatorQueryCondition)super.clone();
        clone.childCondition = ObjectUtil.clone(this.childCondition);
        return clone;
    }
}

