/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.row;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.provider.RowSqlProvider;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryMethods;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.MapperUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.exceptions.TooManyResultsException;

public interface RowMapper {
    public static final int DEFAULT_BATCH_SIZE = 1000;

    @InsertProvider(value=RowSqlProvider.class, method="insert")
    public int insert(@Param(value="$$schemaName") String var1, @Param(value="$$tableName") String var2, @Param(value="$$row") Row var3);

    @InsertProvider(value=RowSqlProvider.class, method="providerRawSql")
    public int insertBySql(@Param(value="$$sql") String var1, Object ... var2);

    @InsertProvider(value=RowSqlProvider.class, method="insertBatchWithFirstRowColumns")
    public int insertBatchWithFirstRowColumns(@Param(value="$$schemaName") String var1, @Param(value="$$tableName") String var2, @Param(value="$$rows") List<Row> var3);

    @DeleteProvider(value=RowSqlProvider.class, method="providerRawSql")
    public int deleteBySql(@Param(value="$$sql") String var1, Object ... var2);

    default public int deleteById(String schema, String tableName, Row row) {
        return this.deleteById(schema, tableName, StringUtil.join(",", row.obtainsPrimaryKeyStrings()), row.obtainsPrimaryValues());
    }

    @DeleteProvider(value=RowSqlProvider.class, method="deleteById")
    public int deleteById(@Param(value="$$schemaName") String var1, @Param(value="$$tableName") String var2, @Param(value="$$primaryKey") String var3, @Param(value="$$primaryValue") Object var4);

    @DeleteProvider(value=RowSqlProvider.class, method="deleteBatchByIds")
    public int deleteBatchByIds(@Param(value="$$schemaName") String var1, @Param(value="$$tableName") String var2, @Param(value="$$primaryKey") String var3, @Param(value="$$primaryValue") Collection<?> var4);

    @DeleteProvider(value=RowSqlProvider.class, method="deleteByQuery")
    public int deleteByQuery(@Param(value="$$schemaName") String var1, @Param(value="$$tableName") String var2, @Param(value="$$query") QueryWrapper var3);

    @UpdateProvider(value=RowSqlProvider.class, method="providerRawSql")
    public int updateBySql(@Param(value="$$sql") String var1, Object ... var2);

    @UpdateProvider(value=RowSqlProvider.class, method="updateById")
    public int updateById(@Param(value="$$schemaName") String var1, @Param(value="$$tableName") String var2, @Param(value="$$row") Row var3);

    @UpdateProvider(value=RowSqlProvider.class, method="updateByQuery")
    public int updateByQuery(@Param(value="$$schemaName") String var1, @Param(value="$$tableName") String var2, @Param(value="$$row") Row var3, @Param(value="$$query") QueryWrapper var4);

    @UpdateProvider(value=RowSqlProvider.class, method="updateBatchById")
    public int updateBatchById(@Param(value="$$schemaName") String var1, @Param(value="$$tableName") String var2, @Param(value="$$rows") List<Row> var3);

    @UpdateProvider(value=RowSqlProvider.class, method="updateEntity")
    public int updateEntity(@Param(value="$$entity") Object var1);

    @UpdateProvider(type=RowSqlProvider.class, method="updateNumberAddByQuery")
    public int updateNumberAddByQuery(@Param(value="$$schemaName") String var1, @Param(value="$$tableName") String var2, @Param(value="$$fieldName") String var3, @Param(value="$$value") Number var4, @Param(value="$$query") QueryWrapper var5);

    default public int updateNumberAddByQuery(String tableName, String fieldName, Number value, QueryWrapper queryWrapper) {
        return this.updateNumberAddByQuery(null, tableName, fieldName, value, queryWrapper);
    }

    default public Row selectOneBySql(String sql, Object ... args) {
        List<Row> rows = this.selectListBySql(sql, args);
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        if (rows.size() == 1) {
            return rows.get(0);
        }
        throw new TooManyResultsException("Expected one result (or null) to be returned by selectOneBySql(), but found: " + rows.size());
    }

    default public Row selectOneById(String schema, String tableName, Row row) {
        return this.selectOneById(schema, tableName, StringUtil.join(",", row.obtainsPrimaryKeyStrings()), row.obtainsPrimaryValues());
    }

    @SelectProvider(value=RowSqlProvider.class, method="selectOneById")
    public Row selectOneById(@Param(value="$$schemaName") String var1, @Param(value="$$tableName") String var2, @Param(value="$$primaryKey") String var3, @Param(value="$$primaryValue") Object var4);

    default public Row selectOneByQuery(String schema, String tableName, QueryWrapper queryWrapper) {
        List<Row> rows = this.selectListByQuery(schema, tableName, queryWrapper.limit(1));
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        return rows.get(0);
    }

    @SelectProvider(value=RowSqlProvider.class, method="providerRawSql")
    public List<Row> selectListBySql(@Param(value="$$sql") String var1, Object ... var2);

    @SelectProvider(value=RowSqlProvider.class, method="selectListByQuery")
    public List<Row> selectListByQuery(@Param(value="$$schemaName") String var1, @Param(value="$$tableName") String var2, @Param(value="$$query") QueryWrapper var3);

    default public List<Row> selectAll(String schema, String tableName) {
        return this.selectListByQuery(schema, tableName, QueryWrapper.create());
    }

    @SelectProvider(value=RowSqlProvider.class, method="providerRawSql")
    public Object selectObject(@Param(value="$$sql") String var1, Object ... var2);

    @SelectProvider(value=RowSqlProvider.class, method="providerRawSql")
    public List<Object> selectObjectList(@Param(value="$$sql") String var1, Object ... var2);

    default public long selectCount(String sql, Object ... args) {
        Object object = this.selectObject(sql, args);
        if (object == null) {
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        throw FlexExceptions.wrap("selectCount error, Can not get number value for sql: %s", sql);
    }

    default public Object selectObjectByQuery(String schema, String tableName, QueryWrapper queryWrapper) {
        queryWrapper.limit(1);
        List<Object> objects = this.selectObjectListByQuery(schema, tableName, queryWrapper);
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        return objects.get(0);
    }

    @SelectProvider(type=RowSqlProvider.class, method="selectObjectByQuery")
    public List<Object> selectObjectListByQuery(@Param(value="$$schemaName") String var1, @Param(value="$$tableName") String var2, @Param(value="$$query") QueryWrapper var3);

    default public long selectCountByQuery(String schema, String tableName, QueryWrapper queryWrapper) {
        List<Object> objects;
        Object object;
        List<QueryColumn> selectColumns = CPI.getSelectColumns(queryWrapper);
        if (CollectionUtil.isEmpty(selectColumns)) {
            queryWrapper.select(QueryMethods.count());
        }
        Object object2 = object = (objects = this.selectObjectListByQuery(schema, tableName, queryWrapper)) == null || objects.isEmpty() ? null : objects.get(0);
        if (object == null) {
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        throw FlexExceptions.wrap("selectCountByQuery error, Can not get number value for queryWrapper: %s", queryWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Page<Row> paginate(String schema, String tableName, Page<Row> page, QueryWrapper queryWrapper) {
        try {
            Page<Row> page2;
            CPI.setFromIfNecessary(queryWrapper, schema, tableName);
            if (page.getTotalRow() < 0L) {
                QueryWrapper countQueryWrapper = page.needOptimizeCountQuery() ? MapperUtil.optimizeCountQueryWrapper(queryWrapper) : MapperUtil.rawCountQueryWrapper(queryWrapper);
                page.setTotalRow(this.selectCountByQuery(schema, tableName, countQueryWrapper));
            }
            if (page.isEmpty()) {
                page2 = page;
                return page2;
            }
            queryWrapper.limit(page.offset(), page.getPageSize());
            page.setRecords(this.selectListByQuery(schema, tableName, queryWrapper));
            page2 = page;
            return page2;
        }
        finally {
            CPI.setLimitRows(queryWrapper, null);
            CPI.setLimitOffset(queryWrapper, null);
        }
    }
}

