/*
 * Decompiled with CFR 0.152.
 */
package com.nhncorp.lucy.security.xss.markup.rule;

import com.nhncorp.lucy.security.xss.markup.rule.CharArraySegment;
import com.nhncorp.lucy.security.xss.markup.rule.Terminal;
import com.nhncorp.lucy.security.xss.markup.rule.Token;

class CharCode
extends Terminal {
    private char code;

    public CharCode(char code) {
        this.code = code;
    }

    public char getCode() {
        return this.code;
    }

    public static char parse(String hexChars) {
        return (char)Integer.parseInt(hexChars, 16);
    }

    public boolean sliceToken(Token parent, CharArraySegment input) {
        boolean isTokenized = false;
        int start = -1;
        int end = -1;
        while (input != null && input.hasRemaining() && this.code == input.getChar()) {
            if (start < 0) {
                start = input.pos();
                end = input.move(1).pos();
            } else {
                end = input.move(1).pos();
            }
            if (this.isRepeat()) continue;
        }
        if (start >= 0 && end > start) {
            parent.appendValue(input.subSegment(start, end));
            isTokenized = true;
        }
        return isTokenized;
    }

    public int matchPos(CharArraySegment input) {
        return this.code > '\uffff' ? input.posOf(Character.toChars(this.code)) : input.posOf(this.code);
    }
}

