/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.AssertionGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class JWTBearerGrant
extends AssertionGrant {
    public static final GrantType GRANT_TYPE = GrantType.JWT_BEARER;
    private final JWT assertion;

    public JWTBearerGrant(JWT assertion) {
        super(GRANT_TYPE);
        if (assertion == null) {
            throw new IllegalArgumentException("The JWT assertion must not be null");
        }
        this.assertion = assertion;
    }

    public JWT getJWTAssertion() {
        return this.assertion;
    }

    @Override
    public String getAssertion() {
        return this.assertion.serialize();
    }

    @Override
    public Map<String, String> toParameters() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("grant_type", GRANT_TYPE.getValue());
        params.put("assertion", this.assertion.serialize());
        return params;
    }

    public static JWTBearerGrant parse(Map<String, String> params) throws ParseException {
        JWT assertion;
        String grantTypeString = params.get("grant_type");
        if (grantTypeString == null) {
            throw new ParseException("Missing \"grant_type\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        if (!GrantType.parse(grantTypeString).equals(GRANT_TYPE)) {
            throw new ParseException("The \"grant_type\" must be " + GRANT_TYPE, OAuth2Error.UNSUPPORTED_GRANT_TYPE);
        }
        String assertionString = params.get("assertion");
        if (assertionString == null || assertionString.trim().isEmpty()) {
            throw new ParseException("Missing or empty \"assertion\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        try {
            assertion = JWTParser.parse((String)assertionString);
        }
        catch (java.text.ParseException e) {
            throw new ParseException("The \"assertion\" is not a JWT: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, e);
        }
        return new JWTBearerGrant(assertion);
    }
}

