/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class OIDCAccessTokenResponse
extends AccessTokenResponse {
    private final JWT idToken;
    private final String idTokenString;

    public OIDCAccessTokenResponse(AccessToken accessToken, RefreshToken refreshToken) {
        this(accessToken, refreshToken, (String)null);
    }

    public OIDCAccessTokenResponse(AccessToken accessToken, RefreshToken refreshToken, JWT idToken) {
        this(accessToken, refreshToken, idToken, null);
    }

    public OIDCAccessTokenResponse(AccessToken accessToken, RefreshToken refreshToken, JWT idToken, Map<String, Object> customParams) {
        super(accessToken, refreshToken, customParams);
        this.idToken = idToken;
        this.idTokenString = null;
    }

    public OIDCAccessTokenResponse(AccessToken accessToken, RefreshToken refreshToken, String idTokenString) {
        this(accessToken, refreshToken, idTokenString, null);
    }

    public OIDCAccessTokenResponse(AccessToken accessToken, RefreshToken refreshToken, String idTokenString, Map<String, Object> customParams) {
        super(accessToken, refreshToken, customParams);
        this.idToken = null;
        this.idTokenString = idTokenString;
    }

    public JWT getIDToken() {
        if (this.idToken != null) {
            return this.idToken;
        }
        if (this.idTokenString != null) {
            try {
                return JWTParser.parse((String)this.idTokenString);
            }
            catch (java.text.ParseException e) {
                return null;
            }
        }
        return null;
    }

    public String getIDTokenString() {
        if (this.idTokenString != null) {
            return this.idTokenString;
        }
        if (this.idToken != null) {
            if (this.idToken.getParsedString() != null) {
                return this.idToken.getParsedString();
            }
            try {
                return this.idToken.serialize();
            }
            catch (IllegalStateException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public JSONObject toJSONObject() throws SerializeException {
        JSONObject o = super.toJSONObject();
        String idTokenOut = this.getIDTokenString();
        if (idTokenOut != null) {
            o.put((Object)"id_token", (Object)idTokenOut);
        }
        return o;
    }

    public static OIDCAccessTokenResponse parse(JSONObject jsonObject) throws ParseException {
        AccessTokenResponse atr = AccessTokenResponse.parse(jsonObject);
        JWT idToken = null;
        if (jsonObject.containsKey((Object)"id_token")) {
            try {
                idToken = JWTParser.parse((String)JSONObjectUtils.getString(jsonObject, "id_token"));
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Couldn't parse ID token: " + e.getMessage(), e);
            }
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.putAll(atr.getCustomParams());
        customParams.remove("id_token");
        return new OIDCAccessTokenResponse(atr.getAccessToken(), atr.getRefreshToken(), idToken, customParams);
    }

    public static OIDCAccessTokenResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(200);
        JSONObject jsonObject = httpResponse.getContentAsJSONObject();
        return OIDCAccessTokenResponse.parse(jsonObject);
    }
}

