/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud;

public class Scope {
    private static final String ALLOW = "allow";
    private static final String DENY = "deny";
    private String action;
    private String bucket;
    private String region;
    private String sourcePrefix;
    private String effect = "allow";
    private String condition = null;

    public Scope(String action, String bucket, String region, String sourcePrefix) {
        this.action = action;
        this.bucket = bucket;
        this.region = region;
        this.sourcePrefix = sourcePrefix;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setResourcePrefix(String sourcePrefix) {
        this.sourcePrefix = sourcePrefix;
    }

    public void isAllow(boolean isAllow) {
        this.effect = isAllow ? ALLOW : DENY;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getAction() {
        if (this.action == null) {
            throw new NullPointerException("action == null");
        }
        return this.action;
    }

    public String getEffect() {
        return this.effect;
    }

    public String getResource() {
        if (this.bucket == null) {
            throw new NullPointerException("bucket == null");
        }
        if (this.sourcePrefix == null) {
            throw new NullPointerException("sourcePrefix == null");
        }
        int index = this.bucket.lastIndexOf(45);
        if (index < 0) {
            throw new IllegalStateException("bucket format is invalid: " + this.bucket);
        }
        String appid = this.bucket.substring(index + 1).trim();
        if (!this.sourcePrefix.startsWith("/")) {
            this.sourcePrefix = '/' + this.sourcePrefix;
        }
        StringBuilder resource = new StringBuilder();
        resource.append("qcs::cos").append(':').append(this.region).append(':').append("uid/").append(appid).append(':').append(this.bucket).append(this.sourcePrefix);
        return resource.toString();
    }

    public String getCondition() {
        return this.condition;
    }
}

