/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.ws.FutureResponse;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.schemaless.SchemalessAction;
import com.taosdata.jdbc.ws.tmq.ConsumerAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;

public class InFlightRequest {
    private final int timeout;
    private final Semaphore semaphore;
    private final Map<String, ConcurrentHashMap<Long, FutureResponse>> futureMap = new HashMap<String, ConcurrentHashMap<Long, FutureResponse>>();

    public InFlightRequest(int timeout, int concurrentNum) {
        String action;
        this.timeout = timeout;
        this.semaphore = new Semaphore(concurrentNum);
        for (Action action2 : Action.values()) {
            action = action2.getAction();
            this.futureMap.put(action, new ConcurrentHashMap());
        }
        for (Enum enum_ : ConsumerAction.values()) {
            action = ((ConsumerAction)enum_).getAction();
            this.futureMap.put(action, new ConcurrentHashMap());
        }
        for (Enum enum_ : SchemalessAction.values()) {
            action = ((SchemalessAction)enum_).getAction();
            this.futureMap.put(action, new ConcurrentHashMap());
        }
    }

    public void put(FutureResponse rf) throws InterruptedException, TimeoutException {
        if (!this.semaphore.tryAcquire(this.timeout, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("websocket connection reached the max number of concurrent requests");
        }
        this.futureMap.get(rf.getAction()).put(rf.getId(), rf);
    }

    public FutureResponse remove(String action, Long id) {
        if (action.equals("version") && (id == null || id == 0L) && this.futureMap.get(action).size() == 1) {
            Optional optionalLong = this.futureMap.get(action).keySet().stream().findFirst();
            if (!optionalLong.isPresent()) {
                return null;
            }
            id = (Long)optionalLong.get();
            FutureResponse future = this.futureMap.get(action).remove(id);
            if (null != future) {
                this.semaphore.release();
            }
            return future;
        }
        FutureResponse future = this.futureMap.get(action).remove(id);
        if (null != future) {
            this.semaphore.release();
        }
        return future;
    }

    public void close() {
        ((Stream)this.futureMap.keySet().stream().flatMap(k -> {
            ConcurrentHashMap<Long, FutureResponse> futures = this.futureMap.get(k);
            this.futureMap.put((String)k, new ConcurrentHashMap());
            return futures.values().stream();
        }).parallel()).map(FutureResponse::getFuture).forEach(e -> e.completeExceptionally(new Exception("close all inFlightRequest")));
    }

    public boolean hasInFlightRequest() {
        return this.futureMap.keySet().stream().filter(k -> !this.futureMap.get(k).isEmpty()).findAny().orElse(null) != null;
    }
}

