/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class ReqId {
    private static final long tUUIDHashId;
    private static final long pid;
    private static AtomicLong serialNo;

    private ReqId() {
    }

    public static long getReqID() {
        long ts = System.currentTimeMillis() >> 8 & 0x3FFFFFFL;
        long val = serialNo.incrementAndGet();
        return tUUIDHashId | pid | ts << 20 | val & 0xFFFFFL;
    }

    public static long murmurHash32(byte[] data, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int r1 = 15;
        int r2 = 13;
        int m = 5;
        int n = -430675100;
        int hash = seed;
        int length = data.length;
        for (int i = 0; i < length / 4; ++i) {
            int k = ByteBuffer.wrap(data, i * 4, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
            k *= -862048943;
            k = Integer.rotateLeft(k, 15);
            hash ^= (k *= 461845907);
            hash = Integer.rotateLeft(hash, 13);
            hash = hash * 5 + -430675100;
        }
        int k = 0;
        switch (length & 3) {
            case 3: {
                k ^= data[length - 3] << 16;
            }
            case 2: {
                k ^= data[length - 2] << 8;
            }
            case 1: {
                k ^= data[length - 1];
                k *= -862048943;
                k = Integer.rotateLeft(k, 15);
                hash ^= (k *= 461845907);
            }
        }
        hash ^= length;
        hash ^= hash >>> 16;
        hash *= -2048144789;
        hash ^= hash >>> 13;
        hash *= -1028477387;
        hash ^= hash >>> 16;
        return Integer.toUnsignedLong(hash);
    }

    static {
        serialNo = new AtomicLong(0L);
        String uuid = UUID.randomUUID().toString();
        long hash = ReqId.murmurHash32(uuid.getBytes(StandardCharsets.UTF_8), uuid.length());
        tUUIDHashId = (hash & 0x7FFL) << 52;
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        pid = (long)(Long.valueOf(runtimeMXBean.getName().split("@")[0]).intValue() & 0xF) << 48;
    }
}

