/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.drm.v20181115.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GenerateTDRMKeyResponse extends AbstractModel {

    /**
    * 内容ID。
    */
    @SerializedName("ContentId")
    @Expose
    private String ContentId;

    /**
    * 加密密钥。
    */
    @SerializedName("TXEncryptionToken")
    @Expose
    private String TXEncryptionToken;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 内容ID。 
     * @return ContentId 内容ID。
     */
    public String getContentId() {
        return this.ContentId;
    }

    /**
     * Set 内容ID。
     * @param ContentId 内容ID。
     */
    public void setContentId(String ContentId) {
        this.ContentId = ContentId;
    }

    /**
     * Get 加密密钥。 
     * @return TXEncryptionToken 加密密钥。
     */
    public String getTXEncryptionToken() {
        return this.TXEncryptionToken;
    }

    /**
     * Set 加密密钥。
     * @param TXEncryptionToken 加密密钥。
     */
    public void setTXEncryptionToken(String TXEncryptionToken) {
        this.TXEncryptionToken = TXEncryptionToken;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public GenerateTDRMKeyResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GenerateTDRMKeyResponse(GenerateTDRMKeyResponse source) {
        if (source.ContentId != null) {
            this.ContentId = new String(source.ContentId);
        }
        if (source.TXEncryptionToken != null) {
            this.TXEncryptionToken = new String(source.TXEncryptionToken);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ContentId", this.ContentId);
        this.setParamSimple(map, prefix + "TXEncryptionToken", this.TXEncryptionToken);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

