/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.IORMNotSupportedHostOnDatastore;
import com.vmware.vim25.InaccessibleDatastore;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.StorageDrsConfigSpec;
import com.vmware.vim25.StorageIORMConfigOption;
import com.vmware.vim25.StorageIORMConfigSpec;
import com.vmware.vim25.StoragePerformanceSummary;
import com.vmware.vim25.StoragePlacementResult;
import com.vmware.vim25.StoragePlacementSpec;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.StoragePod;
import com.vmware.vim25.mo.Task;
import java.rmi.RemoteException;

public class StorageResourceManager
extends ManagedObject {
    public StorageResourceManager(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public Task applyStorageDrsRecommendation_Task(String[] keys) throws RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().applyStorageDrsRecommendation_Task(this.getMOR(), keys);
        return new Task(this.getServerConnection(), taskMor);
    }

    public Task applyStorageDrsRecommendationToPod_Task(StoragePod pod, String key) throws RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().applyStorageDrsRecommendationToPod_Task(this.getMOR(), pod.getMOR(), key);
        return new Task(this.getServerConnection(), taskMor);
    }

    public void cancelStorageDrsRecommendation(String[] keys) throws RuntimeFault, RemoteException {
        this.getVimService().cancelStorageDrsRecommendation(this.getMOR(), keys);
    }

    public Task configureDatastoreIORM_Task(Datastore datastore, StorageIORMConfigSpec spec) throws InaccessibleDatastore, IORMNotSupportedHostOnDatastore, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().configureDatastoreIORM_Task(this.getMOR(), datastore.getMOR(), spec);
        return new Task(this.getServerConnection(), mor);
    }

    public Task configureStorageDrsForPod_Task(StoragePod pod, StorageDrsConfigSpec spec, boolean modify) throws RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().configureStorageDrsForPod_Task(this.getMOR(), pod.getMOR(), spec, modify);
        return new Task(this.getServerConnection(), taskMor);
    }

    public StoragePerformanceSummary[] queryDatastorePerformanceSummary(Datastore datastore) throws NotFound, RuntimeFault, RemoteException {
        return this.getVimService().queryDatastorePerformanceSummary(this.getMOR(), datastore.getMOR());
    }

    public StorageIORMConfigOption queryIORMConfigOption(HostSystem host) throws RuntimeFault, RemoteException {
        return this.getVimService().queryIORMConfigOption(this.getMOR(), host.getMOR());
    }

    public StoragePlacementResult recommendDatastores(StoragePlacementSpec storageSpec) throws RuntimeFault, RemoteException {
        return this.getVimService().recommendDatastores(this.getMOR(), storageSpec);
    }

    public void refreshStorageDrsRecommendation(StoragePod pod) throws RuntimeFault, RemoteException {
        this.getVimService().refreshStorageDrsRecommendation(this.getMOR(), pod.getMOR());
    }
}

