/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.videoaiot.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.model.ApiInfo;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.video_aiot.request.CloudRecordPlayRequest;
import com.volcengine.model.video_aiot.request.CreateDeviceRequest;
import com.volcengine.model.video_aiot.request.CreateRecordPlanRequest;
import com.volcengine.model.video_aiot.request.CreateSpaceRequest;
import com.volcengine.model.video_aiot.request.CreateStreamRequest;
import com.volcengine.model.video_aiot.request.DeleteCruiseTrackRequest;
import com.volcengine.model.video_aiot.request.DeviceCloudControlRequest;
import com.volcengine.model.video_aiot.request.DeviceCruiseControlRequest;
import com.volcengine.model.video_aiot.request.DeviceQueryPresetRequest;
import com.volcengine.model.video_aiot.request.DeviceRequest;
import com.volcengine.model.video_aiot.request.GetCruiseTrackRequest;
import com.volcengine.model.video_aiot.request.GetDataProjectWithBindWidthAndFlowRequest;
import com.volcengine.model.video_aiot.request.GetDeviceChannelRequest;
import com.volcengine.model.video_aiot.request.GetDeviceChannelV2Request;
import com.volcengine.model.video_aiot.request.GetDeviceRequest;
import com.volcengine.model.video_aiot.request.GetRecordListRequest;
import com.volcengine.model.video_aiot.request.GetRecordListV2Request;
import com.volcengine.model.video_aiot.request.GetRecordListV3Request;
import com.volcengine.model.video_aiot.request.GetStreamDataRequest;
import com.volcengine.model.video_aiot.request.GetStreamRequest;
import com.volcengine.model.video_aiot.request.ListAlarmNotifyRequest;
import com.volcengine.model.video_aiot.request.ListCruiseTracksRequest;
import com.volcengine.model.video_aiot.request.ListDeviceRecordsRequest;
import com.volcengine.model.video_aiot.request.ListDeviceRequest;
import com.volcengine.model.video_aiot.request.ListRecordPlansRequest;
import com.volcengine.model.video_aiot.request.ListSpaceRequest;
import com.volcengine.model.video_aiot.request.ListStreamRecordsRequestV3;
import com.volcengine.model.video_aiot.request.ListStreamsRequest;
import com.volcengine.model.video_aiot.request.LocalMediaDownloadRequest;
import com.volcengine.model.video_aiot.request.PlayCloudRecordRequest;
import com.volcengine.model.video_aiot.request.PlaybackControlRequest;
import com.volcengine.model.video_aiot.request.PlaybackStartRequest;
import com.volcengine.model.video_aiot.request.PlaybackStartRequestV2;
import com.volcengine.model.video_aiot.request.ResetAlarmRequest;
import com.volcengine.model.video_aiot.request.SetAlarmGuardRequest;
import com.volcengine.model.video_aiot.request.SetCruiseTrackRequest;
import com.volcengine.model.video_aiot.request.SetSpaceTemplateRequest;
import com.volcengine.model.video_aiot.request.StartCruiseTrackRequest;
import com.volcengine.model.video_aiot.request.StartVoiceTalkRequest;
import com.volcengine.model.video_aiot.request.StatStreamRequest;
import com.volcengine.model.video_aiot.request.StopCruiseTrackRequest;
import com.volcengine.model.video_aiot.request.StopVoiceTalkRequest;
import com.volcengine.model.video_aiot.request.StreamLogsRequest;
import com.volcengine.model.video_aiot.request.StreamRequest;
import com.volcengine.model.video_aiot.request.StreamStartRecordRequest;
import com.volcengine.model.video_aiot.request.UpdateAuthInSpaceRequest;
import com.volcengine.model.video_aiot.request.UpdateDeviceRequest;
import com.volcengine.model.video_aiot.request.UpdateRecordPlanRequest;
import com.volcengine.model.video_aiot.request.UpdateSpaceRequest;
import com.volcengine.model.video_aiot.request.UpdateStreamRequest;
import com.volcengine.model.video_aiot.response.CloudPlayResponse;
import com.volcengine.model.video_aiot.response.CreateDeviceResponse;
import com.volcengine.model.video_aiot.response.DeleteStreamRecordResponse;
import com.volcengine.model.video_aiot.response.DeviceQueryPresetResponse;
import com.volcengine.model.video_aiot.response.GetCruiseTrackResponse;
import com.volcengine.model.video_aiot.response.GetDataProjectWithBindWidthAndFlowResponse;
import com.volcengine.model.video_aiot.response.GetDeviceChannelResponse;
import com.volcengine.model.video_aiot.response.GetDeviceChannelV2Response;
import com.volcengine.model.video_aiot.response.GetDeviceResponse;
import com.volcengine.model.video_aiot.response.GetLocalMediaDownloadResponse;
import com.volcengine.model.video_aiot.response.GetRecordResponse;
import com.volcengine.model.video_aiot.response.GetRecordV2Response;
import com.volcengine.model.video_aiot.response.GetRecordV3Response;
import com.volcengine.model.video_aiot.response.GetStreamDataResponse;
import com.volcengine.model.video_aiot.response.GetStreamRecordResponse;
import com.volcengine.model.video_aiot.response.GetStreamResponse;
import com.volcengine.model.video_aiot.response.GetTotalDataResponse;
import com.volcengine.model.video_aiot.response.IDResponse;
import com.volcengine.model.video_aiot.response.ListAlarmNotifyResponse;
import com.volcengine.model.video_aiot.response.ListCruiseTracksResponse;
import com.volcengine.model.video_aiot.response.ListDeviceRecordsResponse;
import com.volcengine.model.video_aiot.response.ListDeviceResponse;
import com.volcengine.model.video_aiot.response.ListRecordPlanChannelsResponse;
import com.volcengine.model.video_aiot.response.ListRecordPlansResponse;
import com.volcengine.model.video_aiot.response.ListSpaceResponse;
import com.volcengine.model.video_aiot.response.ListStreamRecordsResponseV3;
import com.volcengine.model.video_aiot.response.ListStreamsResponse;
import com.volcengine.model.video_aiot.response.LocalMediaDownloadResponse;
import com.volcengine.model.video_aiot.response.PlayCloudResponse;
import com.volcengine.model.video_aiot.response.PlaybackStartResponse;
import com.volcengine.model.video_aiot.response.PlaybackStatResponse;
import com.volcengine.model.video_aiot.response.RawResponse;
import com.volcengine.model.video_aiot.response.RecordPlanResponse;
import com.volcengine.model.video_aiot.response.SpaceResponse;
import com.volcengine.model.video_aiot.response.SpaceTemplateResponse;
import com.volcengine.model.video_aiot.response.StartStreamResponse;
import com.volcengine.model.video_aiot.response.StartVoiceTalkResponse;
import com.volcengine.model.video_aiot.response.StatStreamResponse;
import com.volcengine.model.video_aiot.response.StreamLogsResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.live.LiveConfig;
import com.volcengine.service.videoaiot.VideoAIoTConfig;
import com.volcengine.service.videoaiot.VideoAIoTService;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class VideoAIoTServiceImpl
extends BaseServiceImpl
implements VideoAIoTService {
    private static final List<NameValuePair> emptyList = new ArrayList<NameValuePair>();

    private VideoAIoTServiceImpl() {
        super(VideoAIoTConfig.serviceInfoMap.get("cn-north-1"), VideoAIoTConfig.apiInfoList);
    }

    private VideoAIoTServiceImpl(ServiceInfo serviceInfo) {
        super(serviceInfo, VideoAIoTConfig.apiInfoList);
    }

    private VideoAIoTServiceImpl(ServiceInfo info, HttpHost proxy, Map<String, ApiInfo> apiInfoList) {
        super(info, proxy, apiInfoList);
    }

    private VideoAIoTServiceImpl(ServiceInfo info, Map<String, ApiInfo> apiInfoList) {
        super(info, apiInfoList);
    }

    public static VideoAIoTService getInstance() {
        return new VideoAIoTServiceImpl();
    }

    public static VideoAIoTService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = LiveConfig.serviceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("AIoTVideo not support region " + region);
        }
        return new VideoAIoTServiceImpl(serviceInfo);
    }

    @Override
    public IDResponse createSpace(CreateSpaceRequest createSpaceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("CreateSpace", emptyList, JSON.toJSONString((Object)createSpaceRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public SpaceResponse getSpace(final String spaceID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GetSpace", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (SpaceResponse)JSON.parseObject((byte[])response.getData(), SpaceResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListSpaceResponse listSpace(final ListSpaceRequest listSpaceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("ListSpaces", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("PageNumber", Integer.toString(listSpaceRequest.getPageNumber())));
                this.add(new BasicNameValuePair("PageSize", Integer.toString(listSpaceRequest.getPageSize())));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListSpaceResponse)JSON.parseObject((byte[])response.getData(), ListSpaceResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse startSpace(final String spaceID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StartSpace", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetDataProjectWithBindWidthAndFlowResponse getDataProjectWithBindWidthAndFlow(final GetDataProjectWithBindWidthAndFlowRequest getDataProjectWithBindWidthAndFlow) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("GetDataProjectWithBindWidthAndFlow", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", getDataProjectWithBindWidthAndFlow.getSpaceID()));
                this.add(new BasicNameValuePair("StartTime", getDataProjectWithBindWidthAndFlow.getStartTime()));
                this.add(new BasicNameValuePair("EndTime", getDataProjectWithBindWidthAndFlow.getEndTime()));
                this.add(new BasicNameValuePair("Data", getDataProjectWithBindWidthAndFlow.getData()));
                this.add(new BasicNameValuePair("StreamName", getDataProjectWithBindWidthAndFlow.getStreamName()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetDataProjectWithBindWidthAndFlowResponse)JSON.parseObject((byte[])response.getData(), GetDataProjectWithBindWidthAndFlowResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetTotalDataResponse getTotalData(final String time) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("GetTotalData", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("Time", time));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetTotalDataResponse)JSON.parseObject((byte[])response.getData(), GetTotalDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse stopSpace(final String spaceID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StopSpace", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse deleteSpace(final String spaceID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("DeleteSpace", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse updateSpace(final UpdateSpaceRequest updateSpaceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("UpdateSpace", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", updateSpaceRequest.getSpaceID()));
            }
        }, JSON.toJSONString((Object)updateSpaceRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse setSpaceTemplate(final SetSpaceTemplateRequest setSpaceTemplateRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("SetSpaceTemplate", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", setSpaceTemplateRequest.getSpaceID()));
                this.add(new BasicNameValuePair("TemplateType", setSpaceTemplateRequest.getTemplateType()));
            }
        }, JSON.toJSONString((Object)setSpaceTemplateRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse unsetSpaceTemplate(final String spaceID, final String templateType) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("CancelBindTemplate", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
                this.add(new BasicNameValuePair("TemplateType", templateType));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public SpaceTemplateResponse getSpaceTemplate(final String spaceID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GetSpaceTemplate", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (SpaceTemplateResponse)JSON.parseObject((byte[])response.getData(), SpaceTemplateResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse updateAuthInSpace(UpdateAuthInSpaceRequest updateAuthInSpace) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("UpdateAuthInSpace", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)updateAuthInSpace));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse disableAuthInSpace(final String spaceID, final String domain) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("DisableAuthInSpace", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
                this.add(new BasicNameValuePair("Domain", domain));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CreateDeviceResponse createDevice(final CreateDeviceRequest createDeviceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("CreateDevice", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", createDeviceRequest.getSpaceID()));
            }
        }, JSON.toJSONString((Object)createDeviceRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CreateDeviceResponse)JSON.parseObject((byte[])response.getData(), CreateDeviceResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListDeviceResponse listDevice(final ListDeviceRequest listDeviceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response;
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", listDeviceRequest.getSpaceID()));
                this.add(new BasicNameValuePair("PageSize", Integer.toString(listDeviceRequest.getPageSize())));
                this.add(new BasicNameValuePair("PageNumber", Integer.toString(listDeviceRequest.getPageNumber())));
            }
        };
        if (listDeviceRequest.getDeviceName() != null) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("DeviceName", listDeviceRequest.getDeviceName()));
        }
        if ((response = this.query("ListDevices", (List<NameValuePair>)nameValuePairs)).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListDeviceResponse)JSON.parseObject((byte[])response.getData(), ListDeviceResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetDeviceResponse getDevice(final GetDeviceRequest getDeviceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GetDevice", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", getDeviceRequest.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceID", getDeviceRequest.getDeviceID()));
                this.add(new BasicNameValuePair("SipServerID", getDeviceRequest.getSipServerID()));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetDeviceResponse)JSON.parseObject((byte[])response.getData(), GetDeviceResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public LocalMediaDownloadResponse localMediaDownload(final LocalMediaDownloadRequest localMediaDownloadRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("LocalMediaDownload", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", localMediaDownloadRequest.getSpaceID()));
            }
        }, JSON.toJSONString((Object)localMediaDownloadRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (LocalMediaDownloadResponse)JSON.parseObject((byte[])response.getData(), LocalMediaDownloadResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetLocalMediaDownloadResponse getLocalDownload(final String id) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("GetLocalDownload", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("ID", id));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetLocalMediaDownloadResponse)JSON.parseObject((byte[])response.getData(), GetLocalMediaDownloadResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse freshDevice(final DeviceRequest freshDeviceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("FreshDevice", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", freshDeviceRequest.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceID", freshDeviceRequest.getDeviceID()));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse startDevice(final DeviceRequest startDevice) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StartDevice", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", startDevice.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceID", startDevice.getDeviceID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse stopDevice(final DeviceRequest stopDevice) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StopDevice", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", stopDevice.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceID", stopDevice.getDeviceID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse deleteDevice(final DeviceRequest deleteDevice) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("DeleteDevice", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", deleteDevice.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceID", deleteDevice.getDeviceID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse updateDevice(final UpdateDeviceRequest updateDeviceRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("UpdateDevice", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", updateDeviceRequest.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceID", updateDeviceRequest.getDeviceID()));
            }
        }, JSON.toJSONString((Object)updateDeviceRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListDeviceRecordsResponse listDeviceScreenshots(final ListDeviceRecordsRequest listDeviceRecordsRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("ListDeviceScreenshots", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", listDeviceRecordsRequest.getSpaceID()));
                this.add(new BasicNameValuePair("StreamID", listDeviceRecordsRequest.getStreamID()));
                this.add(new BasicNameValuePair("PageNumber", Integer.toString(listDeviceRecordsRequest.getPageNumber())));
                this.add(new BasicNameValuePair("PageSize", Integer.toString(listDeviceRecordsRequest.getPageSize())));
            }
        }, JSON.toJSONString((Object)listDeviceRecordsRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListDeviceRecordsResponse)JSON.parseObject((byte[])response.getData(), ListDeviceRecordsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListDeviceRecordsResponse listDeviceRecords(final ListDeviceRecordsRequest listDeviceRecordsRequest) throws Exception {
        com.volcengine.model.response.RawResponse response;
        if (listDeviceRecordsRequest.getReqType() == null) {
            listDeviceRecordsRequest.setReqType("");
        }
        if ((response = this.json("ListDeviceRecords", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", listDeviceRecordsRequest.getSpaceID()));
                this.add(new BasicNameValuePair("StreamID", listDeviceRecordsRequest.getStreamID()));
                this.add(new BasicNameValuePair("PageNumber", Integer.toString(listDeviceRecordsRequest.getPageNumber())));
                this.add(new BasicNameValuePair("PageSize", Integer.toString(listDeviceRecordsRequest.getPageSize())));
                this.add(new BasicNameValuePair("DeviceNSID", listDeviceRecordsRequest.getDeviceNSID()));
                this.add(new BasicNameValuePair("ChannelID", listDeviceRecordsRequest.getChannelID()));
                this.add(new BasicNameValuePair("StreamingIndex", Integer.toString(listDeviceRecordsRequest.getStreamingIndex())));
                this.add(new BasicNameValuePair("Resolution", listDeviceRecordsRequest.getResolution()));
                this.add(new BasicNameValuePair("ReqType", listDeviceRecordsRequest.getReqType()));
                this.add(new BasicNameValuePair("WithSub", listDeviceRecordsRequest.isWithSub() ? "1" : "0"));
            }
        }, JSON.toJSONString((Object)listDeviceRecordsRequest))).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListDeviceRecordsResponse)JSON.parseObject((byte[])response.getData(), ListDeviceRecordsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListStreamRecordsResponseV3 listStreamRecords(final ListStreamRecordsRequestV3 listStreamRecordsRequestV3) throws Exception {
        com.volcengine.model.response.RawResponse response;
        if (listStreamRecordsRequestV3.getReqType() == null) {
            listStreamRecordsRequestV3.setReqType("");
        }
        if ((response = this.json("ListStreamRecords", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("PageNumber", Integer.toString(listStreamRecordsRequestV3.getPageNumber())));
                this.add(new BasicNameValuePair("PageSize", Integer.toString(listStreamRecordsRequestV3.getPageSize())));
            }
        }, JSON.toJSONString((Object)listStreamRecordsRequestV3))).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListStreamRecordsResponseV3)JSON.parseObject((byte[])response.getData(), ListStreamRecordsResponseV3.class, (Feature[])new Feature[0]);
    }

    @Override
    public CloudPlayResponse cloudRecordPlay(CloudRecordPlayRequest cloudRecordPlayArgs) throws Exception {
        if (cloudRecordPlayArgs.getStartTs().getClass() != Integer.class && cloudRecordPlayArgs.getStartTs().getClass() != String.class) {
            throw new InvalidParameterException("startTs object type " + cloudRecordPlayArgs.getStartTs().getClass().getName() + " is not allowed, Integer or String is allowed");
        }
        if (cloudRecordPlayArgs.getEndTs().getClass() != Integer.class && cloudRecordPlayArgs.getEndTs().getClass() != String.class) {
            throw new InvalidParameterException("endTs object type " + cloudRecordPlayArgs.getStartTs().getClass().getName() + " is not allowed, Integer or String is allowed");
        }
        com.volcengine.model.response.RawResponse response = this.json("CloudRecordPlay", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)cloudRecordPlayArgs));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CloudPlayResponse)JSON.parseObject((byte[])response.getData(), CloudPlayResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public PlayCloudResponse playCloudRecord(PlayCloudRecordRequest playCloudRecordRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("PlayCloudRecord", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)playCloudRecordRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (PlayCloudResponse)JSON.parseObject((byte[])response.getData(), PlayCloudResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse genSipID(final String sipServerID, final String deviceType) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GenSipID", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SipServerID", sipServerID));
                this.add(new BasicNameValuePair("DeviceType", deviceType));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse genSipIDBySpaceID(final String spaceID, final String deviceType) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GenSipID", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
                this.add(new BasicNameValuePair("DeviceType", deviceType));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetDeviceChannelResponse getDeviceChannels(final GetDeviceChannelRequest getDeviceChannelRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GetDeviceChannels", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("DeviceID", getDeviceChannelRequest.getDeviceID()));
                this.add(new BasicNameValuePair("QueryMode", getDeviceChannelRequest.getQueryMode()));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetDeviceChannelResponse)JSON.parseObject((byte[])response.getData(), GetDeviceChannelResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetDeviceChannelV2Response getDeviceChannelsV2(final GetDeviceChannelV2Request getDeviceChannelRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GetDeviceChannelsV2", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("DeviceID", getDeviceChannelRequest.getDeviceID()));
                this.add(new BasicNameValuePair("QueryMode", getDeviceChannelRequest.getQueryMode()));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetDeviceChannelV2Response)JSON.parseObject((byte[])response.getData(), GetDeviceChannelV2Response.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse setAlarmGuard(final SetAlarmGuardRequest setAlarmGuardRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("SetAlarmGuard", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("DeviceNSID", setAlarmGuardRequest.getDeviceNSID()));
                this.add(new BasicNameValuePair("Enable", setAlarmGuardRequest.getEnable()));
                this.add(new BasicNameValuePair("SipID", setAlarmGuardRequest.getSipID()));
                this.add(new BasicNameValuePair("ChannelID", setAlarmGuardRequest.getChannelID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse resetAlarm(final ResetAlarmRequest resetAlarmRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("ResetAlarm", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("DeviceNSID", resetAlarmRequest.getDeviceNSID()));
                this.add(new BasicNameValuePair("SipID", resetAlarmRequest.getSipID()));
                this.add(new BasicNameValuePair("ChannelID", resetAlarmRequest.getChannelID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListAlarmNotifyResponse listAlarmNotify(ListAlarmNotifyRequest listAlarmNotifyRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("ListAlarmNotify", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)listAlarmNotifyRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListAlarmNotifyResponse)JSON.parseObject((byte[])response.getData(), ListAlarmNotifyResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse deleteAlarmNotify(final String alarmNotifyID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("DeleteAlarmNotify", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("AlarmNotifyID", alarmNotifyID));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse deleteAlarmNotifyAll(final String spaceID, final String deviceNSID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("DeleteAlarmNotifyAll", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", spaceID));
                this.add(new BasicNameValuePair("DeviceID", deviceNSID));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse cloudControl(DeviceCloudControlRequest deviceCloudControlRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("CloudControl", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)deviceCloudControlRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DeviceQueryPresetResponse queryPresetInfo(DeviceQueryPresetRequest queryPresetRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("QueryPresetInfo", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)queryPresetRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DeviceQueryPresetResponse)JSON.parseObject((byte[])response.getData(), DeviceQueryPresetResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse cruiseControl(DeviceCruiseControlRequest deviceCruiseControlRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("CruiseControl", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)deviceCruiseControlRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse setCruiseTrack(SetCruiseTrackRequest setCruiseTrackRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("SetCruiseTrack", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)setCruiseTrackRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetCruiseTrackResponse getCruiseTrack(final GetCruiseTrackRequest getCruiseTrackRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GetCruiseTrack", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("DeviceNSID", getCruiseTrackRequest.getDeviceNSID()));
                this.add(new BasicNameValuePair("ChannelID", getCruiseTrackRequest.getChannelID()));
                this.add(new BasicNameValuePair("TrackID", Integer.toString(getCruiseTrackRequest.getTrackID())));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetCruiseTrackResponse)JSON.parseObject((byte[])response.getData(), GetCruiseTrackResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListCruiseTracksResponse listCruiseTracks(final ListCruiseTracksRequest listCruiseTracksRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("ListCruiseTracks", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("DeviceNSID", listCruiseTracksRequest.getDeviceNSID()));
                this.add(new BasicNameValuePair("ChannelID", listCruiseTracksRequest.getChannelID()));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListCruiseTracksResponse)JSON.parseObject((byte[])response.getData(), ListCruiseTracksResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse deleteCruiseTrack(DeleteCruiseTrackRequest deleteCruiseTrackRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("DeleteCruiseTrack", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)deleteCruiseTrackRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse startCruiseTrack(StartCruiseTrackRequest startCruiseTrackRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StartCruiseTrack", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)startCruiseTrackRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse stopCruiseTrack(StopCruiseTrackRequest stopCruiseTrackRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StopCruiseTrack", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)stopCruiseTrackRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetStreamResponse getStream(final GetStreamRequest getStreamRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GetStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", getStreamRequest.getStreamID()));
                this.add(new BasicNameValuePair("FreshExpiredPull", getStreamRequest.getFreshExpiredPull()));
                this.add(new BasicNameValuePair("FreshExpiredPush", getStreamRequest.getFreshExpiredPush()));
                this.add(new BasicNameValuePair("StreamingIndex", String.valueOf(getStreamRequest.getStreamingIndex())));
                this.add(new BasicNameValuePair("Resolution", getStreamRequest.getResolution()));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetStreamResponse)JSON.parseObject((byte[])response.getData(), GetStreamResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListStreamsResponse listStreams(final ListStreamsRequest listStreamsRequest) throws Exception {
        com.volcengine.model.response.RawResponse response;
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", listStreamsRequest.getSpaceID()));
                this.add(new BasicNameValuePair("PageSize", Integer.toString(listStreamsRequest.getPageSize())));
                this.add(new BasicNameValuePair("PageNumber", Integer.toString(listStreamsRequest.getPageNumber())));
            }
        };
        if (listStreamsRequest.getStreamName() != null) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("StreamName", listStreamsRequest.getStreamName()));
        }
        if ((response = this.query("ListStreams", (List<NameValuePair>)nameValuePairs)).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListStreamsResponse)JSON.parseObject((byte[])response.getData(), ListStreamsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse updateStream(final UpdateStreamRequest updateStreamRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("UpdateStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", updateStreamRequest.getSpaceID()));
                this.add(new BasicNameValuePair("StreamID", updateStreamRequest.getStreamID()));
            }
        }, JSON.toJSONString((Object)updateStreamRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public StartStreamResponse startStream(final StreamRequest startStream) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StartStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", startStream.getStreamID()));
                this.add(new BasicNameValuePair("EnableAudioTranscode", startStream.isEnableAudioTranscode() ? "1" : "0"));
                this.add(new BasicNameValuePair("IgnoreAudio", startStream.isIgnoreAudio() ? "1" : "0"));
            }
        }, JSON.toJSONString((Object)startStream));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (StartStreamResponse)JSON.parseObject((byte[])response.getData(), StartStreamResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse stopStream(final StreamRequest stopStream) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StopStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", stopStream.getStreamID()));
                this.add(new BasicNameValuePair("IsSmart", stopStream.getIsSmart()));
            }
        }, JSON.toJSONString((Object)stopStream));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public StreamLogsResponse streamLogs(final StreamLogsRequest streamLogs) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StreamLogs", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StartTs", streamLogs.getStartTs()));
                this.add(new BasicNameValuePair("EndTs", streamLogs.getEndTs()));
                this.add(new BasicNameValuePair("StreamID", streamLogs.getStreamID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (StreamLogsResponse)JSON.parseObject((byte[])response.getData(), StreamLogsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse createStream(final CreateStreamRequest createStream) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("CreateStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", createStream.getSpaceID()));
            }
        }, JSON.toJSONString((Object)createStream));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse deleteStream(final StreamRequest deleteStream) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("DeleteStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", deleteStream.getStreamID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public StatStreamResponse statStream(StatStreamRequest statStreamRequest) throws Exception {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        com.volcengine.model.response.RawResponse response = this.json("StatStream", pairs, JSON.toJSONString((Object)statStreamRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (StatStreamResponse)JSON.parseObject((byte[])response.getData(), StatStreamResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse streamStartRecord(StreamStartRecordRequest streamStartRecordRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StreamStartRecord", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)streamStartRecordRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse streamStopRecord(final String recordID) throws Exception {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("RecordID", recordID));
            }
        };
        com.volcengine.model.response.RawResponse response = this.query("StreamStopRecord", (List<NameValuePair>)nameValuePairs);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetStreamRecordResponse getStreamRecord(final String recordID) throws Exception {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("RecordID", recordID));
            }
        };
        com.volcengine.model.response.RawResponse response = this.query("GetStreamRecord", (List<NameValuePair>)nameValuePairs);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetStreamRecordResponse)JSON.parseObject((byte[])response.getData(), GetStreamRecordResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DeleteStreamRecordResponse deleteStreamRecord(final String recordID) throws Exception {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("RecordID", recordID));
            }
        };
        com.volcengine.model.response.RawResponse response = this.query("DeleteStreamRecord", (List<NameValuePair>)nameValuePairs);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DeleteStreamRecordResponse)JSON.parseObject((byte[])response.getData(), DeleteStreamRecordResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetStreamDataResponse getStreamData(final GetStreamDataRequest getStreamData) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("GetStreamData", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", getStreamData.getStreamID()));
                this.add(new BasicNameValuePair("StartTime", getStreamData.getStartTime()));
                this.add(new BasicNameValuePair("EndTime", getStreamData.getEndTime()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetStreamDataResponse)JSON.parseObject((byte[])response.getData(), GetStreamDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse forbidStream(final String streamID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("ForbidStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", streamID));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse forbidStream(final StreamRequest streamRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("ForbidStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", streamRequest.getStreamID()));
            }
        }, JSON.toJSONString((Object)streamRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse unForbidStream(final String streamID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("UnforbidStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", streamID));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse allowStream(final StreamRequest streamRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("UnforbidStream", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", streamRequest.getStreamID()));
            }
        }, JSON.toJSONString((Object)streamRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetRecordResponse getRecordList(GetRecordListRequest request) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("GetRecordList", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetRecordResponse)JSON.parseObject((byte[])response.getData(), GetRecordResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetRecordV2Response getRecordListV2(GetRecordListV2Request request) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("GetRecordListV2", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetRecordV2Response)JSON.parseObject((byte[])response.getData(), GetRecordV2Response.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetRecordV3Response getRecordListV3(GetRecordListV3Request request) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("GetRecordListV3", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetRecordV3Response)JSON.parseObject((byte[])response.getData(), GetRecordV3Response.class, (Feature[])new Feature[0]);
    }

    @Override
    public PlaybackStartResponse playbackStart(PlaybackStartRequest request) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("PlaybackStart", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (PlaybackStartResponse)JSON.parseObject((byte[])response.getData(), PlaybackStartResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public PlaybackStartResponse playbackStartV2(PlaybackStartRequestV2 request) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("PlaybackStartV2", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (PlaybackStartResponse)JSON.parseObject((byte[])response.getData(), PlaybackStartResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public PlaybackStatResponse playbackStat(final String playbackStreamID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("PlayBackStat", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", playbackStreamID));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (PlaybackStatResponse)JSON.parseObject((byte[])response.getData(), PlaybackStatResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse playbackStop(final String playbackStreamID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("PlaybackStop", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("StreamID", playbackStreamID));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse playbackControl(PlaybackControlRequest request) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("PlayBackControl", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public StartVoiceTalkResponse startVoiceTalk(final StartVoiceTalkRequest startVoiceTalkRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StartVoiceTalk", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", startVoiceTalkRequest.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceNSID", startVoiceTalkRequest.getDeviceNSID()));
                this.add(new BasicNameValuePair("Transport", startVoiceTalkRequest.transportToString()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (StartVoiceTalkResponse)JSON.parseObject((byte[])response.getData(), StartVoiceTalkResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RawResponse stopVoiceTalk(final StopVoiceTalkRequest stopVoiceTalkRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("StopVoiceTalk", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("SpaceID", stopVoiceTalkRequest.getSpaceID()));
                this.add(new BasicNameValuePair("DeviceNSID", stopVoiceTalkRequest.getDeviceNSID()));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RawResponse)JSON.parseObject((byte[])response.getData(), RawResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse createRecordPlan(CreateRecordPlanRequest createRecordPlanRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("CreateRecordPlan", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)createRecordPlanRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse updateRecordPlan(UpdateRecordPlanRequest updateRecordPlanRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("UpdateRecordPlan", (List<NameValuePair>)new ArrayList<NameValuePair>(){}, JSON.toJSONString((Object)updateRecordPlanRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public IDResponse deleteRecordPlan(final String planID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.json("DeleteRecordPlan", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("PlanID", planID));
            }
        }, "");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (IDResponse)JSON.parseObject((byte[])response.getData(), IDResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RecordPlanResponse getRecordPlan(final String planID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("GetRecordPlan", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("PlanID", planID));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RecordPlanResponse)JSON.parseObject((byte[])response.getData(), RecordPlanResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListRecordPlansResponse listRecordPlans(final ListRecordPlansRequest listRecordPlansRequest) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("ListRecordPlans", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("FilterName", listRecordPlansRequest.getFilterName()));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListRecordPlansResponse)JSON.parseObject((byte[])response.getData(), ListRecordPlansResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListRecordPlanChannelsResponse listRecordPlanChannels(final String planID) throws Exception {
        com.volcengine.model.response.RawResponse response = this.query("ListRecordPlanChannels", (List<NameValuePair>)new ArrayList<NameValuePair>(){
            {
                this.add(new BasicNameValuePair("PlanID", planID));
            }
        });
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListRecordPlanChannelsResponse)JSON.parseObject((byte[])response.getData(), ListRecordPlanChannelsResponse.class, (Feature[])new Feature[0]);
    }
}

