/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.thread;

import com.xxl.job.core.biz.model.HandleCallbackParam;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.biz.model.TriggerParam;
import com.xxl.job.core.executor.XxlJobExecutor;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.log.XxlJobFileAppender;
import com.xxl.job.core.log.XxlJobLogger;
import com.xxl.job.core.thread.TriggerCallbackThread;
import com.xxl.job.core.util.ShardingUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobThread
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(JobThread.class);
    private int jobId;
    private IJobHandler handler;
    private LinkedBlockingQueue<TriggerParam> triggerQueue;
    private Set<Integer> triggerLogIdSet;
    private volatile boolean toStop = false;
    private String stopReason;
    private boolean running = false;
    private int idleTimes = 0;

    public JobThread(int jobId, IJobHandler handler) {
        this.jobId = jobId;
        this.handler = handler;
        this.triggerQueue = new LinkedBlockingQueue();
        this.triggerLogIdSet = Collections.synchronizedSet(new HashSet());
    }

    public IJobHandler getHandler() {
        return this.handler;
    }

    public ReturnT<String> pushTriggerQueue(TriggerParam triggerParam) {
        if (this.triggerLogIdSet.contains(triggerParam.getLogId())) {
            logger.info(">>>>>>>>>>> repeate trigger job, logId:{}", (Object)triggerParam.getLogId());
            return new ReturnT<String>(500, "repeate trigger job, logId:" + triggerParam.getLogId());
        }
        this.triggerLogIdSet.add(triggerParam.getLogId());
        this.triggerQueue.add(triggerParam);
        return ReturnT.SUCCESS;
    }

    public void toStop(String stopReason) {
        this.toStop = true;
        this.stopReason = stopReason;
    }

    public boolean isRunningOrHasQueue() {
        return this.running || this.triggerQueue.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TriggerParam triggerParam;
        try {
            this.handler.init();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        while (!this.toStop) {
            ReturnT<String> stopResult;
            block25: {
                this.running = false;
                ++this.idleTimes;
                triggerParam = null;
                ReturnT<String> executeResult = null;
                try {
                    triggerParam = this.triggerQueue.poll(3L, TimeUnit.SECONDS);
                    if (triggerParam != null) {
                        this.running = true;
                        this.idleTimes = 0;
                        this.triggerLogIdSet.remove(triggerParam.getLogId());
                        String logFileName = XxlJobFileAppender.makeLogFileName(new Date(triggerParam.getLogDateTim()), triggerParam.getLogId());
                        XxlJobFileAppender.contextHolder.set(logFileName);
                        ShardingUtil.setShardingVo(new ShardingUtil.ShardingVO(triggerParam.getBroadcastIndex(), triggerParam.getBroadcastTotal()));
                        XxlJobLogger.log("<br>----------- xxl-job job execute start -----------<br>----------- Param:" + triggerParam.getExecutorParams(), new Object[0]);
                        if (triggerParam.getExecutorTimeout() > 0) {
                            Thread futureThread = null;
                            try {
                                final TriggerParam triggerParamTmp = triggerParam;
                                FutureTask<ReturnT<String>> futureTask = new FutureTask<ReturnT<String>>(new Callable<ReturnT<String>>(){

                                    @Override
                                    public ReturnT<String> call() throws Exception {
                                        return JobThread.this.handler.execute(triggerParamTmp.getExecutorParams());
                                    }
                                });
                                futureThread = new Thread(futureTask);
                                futureThread.start();
                                executeResult = futureTask.get(triggerParam.getExecutorTimeout(), TimeUnit.SECONDS);
                            }
                            catch (TimeoutException e) {
                                XxlJobLogger.log("<br>----------- xxl-job job execute timeout", new Object[0]);
                                XxlJobLogger.log(e);
                                executeResult = new ReturnT(IJobHandler.FAIL_TIMEOUT.getCode(), "job execute timeout ");
                            }
                            finally {
                                futureThread.interrupt();
                            }
                        } else {
                            executeResult = this.handler.execute(triggerParam.getExecutorParams());
                        }
                        if (executeResult == null) {
                            executeResult = IJobHandler.FAIL;
                        }
                        XxlJobLogger.log("<br>----------- xxl-job job execute end(finish) -----------<br>----------- ReturnT:" + executeResult, new Object[0]);
                    } else if (this.idleTimes > 30) {
                        XxlJobExecutor.removeJobThread(this.jobId, "excutor idel times over limit.");
                    }
                    if (triggerParam == null) continue;
                    if (this.toStop) break block25;
                }
                catch (Throwable e) {
                    block26: {
                        try {
                            if (this.toStop) {
                                XxlJobLogger.log("<br>----------- JobThread toStop, stopReason:" + this.stopReason, new Object[0]);
                            }
                            StringWriter stringWriter = new StringWriter();
                            e.printStackTrace(new PrintWriter(stringWriter));
                            String errorMsg = stringWriter.toString();
                            executeResult = new ReturnT<String>(500, errorMsg);
                            XxlJobLogger.log("<br>----------- JobThread Exception:" + errorMsg + "<br>----------- xxl-job job execute end(error) -----------", new Object[0]);
                            if (triggerParam == null) continue;
                            if (this.toStop) break block26;
                        }
                        catch (Throwable throwable) {
                            if (triggerParam != null) {
                                if (!this.toStop) {
                                    TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), triggerParam.getLogDateTim(), executeResult));
                                } else {
                                    ReturnT<String> stopResult2 = new ReturnT<String>(500, this.stopReason + " [job running\uff0ckilled]");
                                    TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), triggerParam.getLogDateTim(), stopResult2));
                                }
                            }
                            throw throwable;
                        }
                        TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), triggerParam.getLogDateTim(), executeResult));
                        continue;
                    }
                    stopResult = new ReturnT(500, this.stopReason + " [job running\uff0ckilled]");
                    TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), triggerParam.getLogDateTim(), stopResult));
                    continue;
                }
                TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), triggerParam.getLogDateTim(), executeResult));
                continue;
            }
            stopResult = new ReturnT<String>(500, this.stopReason + " [job running\uff0ckilled]");
            TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), triggerParam.getLogDateTim(), stopResult));
        }
        while (this.triggerQueue != null && this.triggerQueue.size() > 0) {
            triggerParam = this.triggerQueue.poll();
            if (triggerParam == null) continue;
            ReturnT<String> stopResult = new ReturnT<String>(500, this.stopReason + " [job not executed, in the job queue, killed.]");
            TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), triggerParam.getLogDateTim(), stopResult));
        }
        try {
            this.handler.destroy();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        logger.info(">>>>>>>>>>> xxl-job JobThread stoped, hashCode:{}", (Object)Thread.currentThread());
    }
}

