/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify;

import de.codecentric.boot.admin.event.ClientApplicationStatusChangedEvent;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public abstract class AbstractNotifier {
    protected String[] ignoreChanges = new String[]{"UNKNOWN:UP"};
    private boolean enabled = true;

    @EventListener
    public void onClientApplicationStatusChanged(ClientApplicationStatusChangedEvent event) {
        if (this.enabled && this.shouldNotify(event.getFrom().getStatus(), event.getTo().getStatus())) {
            try {
                this.notify(event);
            }
            catch (Exception ex) {
                this.getLogger().error("Couldn't notify for status change {} ", (Object)event, (Object)ex);
            }
        }
    }

    protected boolean shouldNotify(String from, String to) {
        return Arrays.binarySearch(this.ignoreChanges, from + ":" + to) < 0 && Arrays.binarySearch(this.ignoreChanges, "*:" + to) < 0 && Arrays.binarySearch(this.ignoreChanges, from + ":*") < 0;
    }

    protected abstract void notify(ClientApplicationStatusChangedEvent var1) throws Exception;

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public void setIgnoreChanges(String[] ignoreChanges) {
        Object[] copy = Arrays.copyOf(ignoreChanges, ignoreChanges.length);
        Arrays.sort(copy);
        this.ignoreChanges = copy;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

