/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify.filter.web;

import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.notify.filter.ApplicationNameNotificationFilter;
import de.codecentric.boot.admin.server.notify.filter.FilteringNotifier;
import de.codecentric.boot.admin.server.notify.filter.InstanceIdNotificationFilter;
import de.codecentric.boot.admin.server.notify.filter.NotificationFilter;
import de.codecentric.boot.admin.server.web.AdminController;
import java.time.Instant;
import java.util.Collection;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@AdminController
@ResponseBody
public class NotificationFilterController {
    private final FilteringNotifier filteringNotifier;

    public NotificationFilterController(FilteringNotifier filteringNotifier) {
        this.filteringNotifier = filteringNotifier;
    }

    @GetMapping(path={"/notifications/filters"}, produces={"application/json"})
    public Collection<NotificationFilter> getFilters() {
        return this.filteringNotifier.getNotificationFilters().values();
    }

    @PostMapping(path={"/notifications/filters"}, produces={"application/json"})
    public ResponseEntity<?> addFilter(@RequestParam(name="instanceId", required=false) String instanceId, @RequestParam(name="applicationName", required=false) String name, @RequestParam(name="ttl", required=false) Long ttl) {
        if (StringUtils.hasText((String)instanceId) || StringUtils.hasText((String)name)) {
            NotificationFilter filter = this.createFilter(StringUtils.hasText((String)instanceId) ? InstanceId.of(instanceId) : null, name, ttl);
            this.filteringNotifier.addFilter(filter);
            return ResponseEntity.ok((Object)filter);
        }
        return ResponseEntity.badRequest().body((Object)"Either 'instanceId' or 'applicationName' must be set");
    }

    @DeleteMapping(path={"/notifications/filters/{id}"})
    public ResponseEntity<Void> deleteFilter(@PathVariable(value="id") String id) {
        NotificationFilter deleted = this.filteringNotifier.removeFilter(id);
        if (deleted != null) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    private NotificationFilter createFilter(@Nullable InstanceId id, String name, @Nullable Long ttl) {
        Instant expiry;
        Instant instant = expiry = ttl != null && ttl >= 0L ? Instant.now().plusMillis(ttl) : null;
        if (id != null) {
            return new InstanceIdNotificationFilter(id, expiry);
        }
        return new ApplicationNameNotificationFilter(name, expiry);
    }
}

