/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl;

import io.camunda.client.impl.util.Environment;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuilderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BuilderUtils.class);

    private BuilderUtils() {
    }

    static void appendProperty(StringBuilder sb, String propertyName, Object value) {
        sb.append(propertyName).append(": ").append(value).append("\n");
    }

    public static void applyPropertyValueIfNotNull(Properties properties, Consumer<String> action, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            Optional<String> value = BuilderUtils.getPropertyValue(properties, propertyName);
            value.ifPresent(action);
            if (value.isPresent()) break;
        }
    }

    private static Optional<String> getPropertyValue(Properties properties, String propertyName) {
        return Optional.ofNullable(properties.getProperty(propertyName));
    }

    public static void applyEnvironmentValueIfNotNull(Consumer<String> action, String ... envNames) {
        for (String envName : envNames) {
            Optional<String> value = BuilderUtils.getEnvironmentVariableValue(envName);
            value.ifPresent(action);
            if (value.isPresent()) break;
        }
    }

    private static Optional<String> getEnvironmentVariableValue(String envName) {
        return Optional.ofNullable(Environment.system().get(envName));
    }
}

