/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl;

import io.camunda.client.CredentialsProvider;
import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.SecurityLevel;
import io.grpc.Status;
import java.io.IOException;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CamundaCallCredentials
extends CallCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(CamundaCallCredentials.class);
    private final CredentialsProvider credentialsProvider;
    private boolean securityWarningIssued;

    CamundaCallCredentials(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        if (!this.securityWarningIssued && requestInfo.getSecurityLevel().ordinal() < SecurityLevel.PRIVACY_AND_INTEGRITY.ordinal()) {
            LOG.warn("The request's security level does not guarantee that the credentials will be confidential.");
            this.securityWarningIssued = true;
        }
        appExecutor.execute(() -> {
            try {
                Metadata headers = new Metadata();
                this.credentialsProvider.applyCredentials(CredentialsProvider.CredentialsApplier.ofMetadata(headers));
                applier.apply(headers);
            }
            catch (IOException e) {
                applier.fail(Status.CANCELLED.withCause((Throwable)e));
            }
        });
    }

    public void thisUsesUnstableApi() {
    }
}

