/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.basicauth;

import io.camunda.client.impl.BuilderUtils;
import io.camunda.client.impl.basicauth.BasicAuthCredentialsProvider;

public final class BasicAuthCredentialsProviderBuilder {
    private String username;
    private String password;
    private boolean applyEnvironmentOverrides = true;

    public BasicAuthCredentialsProviderBuilder username(String username) {
        this.username = username;
        return this;
    }

    public BasicAuthCredentialsProviderBuilder password(String password) {
        this.password = password;
        return this;
    }

    public BasicAuthCredentialsProviderBuilder applyEnvironmentOverrides(boolean applyEnvironmentOverrides) {
        this.applyEnvironmentOverrides = applyEnvironmentOverrides;
        return this;
    }

    public BasicAuthCredentialsProvider build() {
        if (this.applyEnvironmentOverrides) {
            BuilderUtils.applyEnvironmentValueIfNotNull(this::username, "CAMUNDA_BASIC_AUTH_USERNAME");
            BuilderUtils.applyEnvironmentValueIfNotNull(this::password, "CAMUNDA_BASIC_AUTH_PASSWORD");
        }
        this.validate();
        return new BasicAuthCredentialsProvider(this.username, this.password);
    }

    private void validate() {
        if (this.username == null || this.username.isEmpty()) {
            throw new IllegalArgumentException(String.format("Username cannot be null or empty. Ensure the username is set explicitly, or through the environment variable '%s'.", "CAMUNDA_BASIC_AUTH_USERNAME"));
        }
        if (this.password == null || this.password.isEmpty()) {
            throw new IllegalArgumentException(String.format("Password cannot be null or empty. Ensure the password is set explicitly, or through the environment variable '%s'.", "CAMUNDA_BASIC_AUTH_PASSWORD"));
        }
    }
}

