/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.AssignRoleToUserCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.AssignRoleToUserResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.AssignRoleToUserResponseImpl;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class AssignRoleToUserCommandImpl
implements AssignRoleToUserCommandStep1,
AssignRoleToUserCommandStep1.AssignRoleToUserCommandStep2,
AssignRoleToUserCommandStep1.AssignRoleToUserCommandStep3 {
    private String roleId;
    private String username;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public AssignRoleToUserCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AssignRoleToUserCommandStep1.AssignRoleToUserCommandStep2 roleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Override
    public AssignRoleToUserCommandStep1.AssignRoleToUserCommandStep3 username(String username) {
        this.username = username;
        return this;
    }

    @Override
    public FinalCommandStep<AssignRoleToUserResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AssignRoleToUserResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.roleId);
        ArgumentUtil.ensureNotNullNorEmpty("username", this.username);
        HttpCamundaFuture<AssignRoleToUserResponse> result = new HttpCamundaFuture<AssignRoleToUserResponse>();
        String endpoint = String.format("/roles/%s/users/%s", this.roleId, this.username);
        this.httpClient.put(endpoint, null, this.httpRequestConfig.build(), AssignRoleToUserResponseImpl::new, result);
        return result;
    }
}

