/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.StatusRequestStep1;
import io.camunda.client.api.response.StatusResponse;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.StatusResponseImpl;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public final class StatusRequestImpl
implements StatusRequestStep1 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private Duration requestTimeout;

    public StatusRequestImpl(HttpClient httpClient, Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalCommandStep<StatusResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public CamundaFuture<StatusResponse> send() {
        HttpCamundaFuture<StatusResponse> result = new HttpCamundaFuture<StatusResponse>();
        Predicate<Integer> successPredicate = status -> status == 204 || status == 503;
        this.httpClient.get("/status", this.httpRequestConfig.setResponseTimeout(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS).build(), successPredicate, StatusResponseImpl::new, result);
        return result;
    }
}

