/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UpdateGroupCommandStep1;
import io.camunda.client.api.response.UpdateGroupResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.UpdateGroupResponseImpl;
import io.camunda.client.protocol.rest.GroupUpdateRequest;
import io.camunda.client.protocol.rest.GroupUpdateResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class UpdateGroupCommandImpl
implements UpdateGroupCommandStep1 {
    private final String groupId;
    private final GroupUpdateRequest request;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public UpdateGroupCommandImpl(String groupId, HttpClient httpClient, JsonMapper jsonMapper) {
        this.groupId = groupId;
        this.request = new GroupUpdateRequest();
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public UpdateGroupCommandStep1 name(String name) {
        this.request.setName(name);
        return this;
    }

    @Override
    public UpdateGroupCommandStep1 description(String description) {
        this.request.setDescription(description);
        return this;
    }

    @Override
    public FinalCommandStep<UpdateGroupResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UpdateGroupResponse> send() {
        ArgumentUtil.ensureNotNull("name", this.request.getName());
        ArgumentUtil.ensureNotNull("description", this.request.getDescription());
        HttpCamundaFuture<UpdateGroupResponse> result = new HttpCamundaFuture<UpdateGroupResponse>();
        UpdateGroupResponseImpl response = new UpdateGroupResponseImpl();
        this.httpClient.put("/groups/" + this.groupId, this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), GroupUpdateResult.class, response::setResponse, result);
        return result;
    }
}

