/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.JobChangeset;
import io.camunda.client.api.command.UpdateJobCommandStep1;
import io.camunda.client.api.response.UpdateJobResponse;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.UpdateJobResponseImpl;
import io.camunda.client.protocol.rest.JobUpdateRequest;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class UpdateJobCommandImpl
implements UpdateJobCommandStep1,
UpdateJobCommandStep1.UpdateJobCommandStep2 {
    private final JobUpdateRequest httpRequestObject;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long jobKey;
    private final JsonMapper jsonMapper;

    public UpdateJobCommandImpl(long jobKey, HttpClient httpClient, JsonMapper jsonMapper) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new JobUpdateRequest();
        this.jobKey = jobKey;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public FinalCommandStep<UpdateJobResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UpdateJobResponse> send() {
        HttpCamundaFuture<UpdateJobResponse> result = new HttpCamundaFuture<UpdateJobResponse>();
        this.httpClient.patch("/jobs/" + this.jobKey, this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), UpdateJobResponseImpl::new, result);
        return result;
    }

    @Override
    public UpdateJobCommandStep1.UpdateJobCommandStep2 update(JobChangeset jobChangeset) {
        io.camunda.client.protocol.rest.JobChangeset changeset = new io.camunda.client.protocol.rest.JobChangeset();
        if (jobChangeset != null) {
            changeset.retries(jobChangeset.getRetries()).timeout(jobChangeset.getTimeout());
        }
        this.httpRequestObject.setChangeset(changeset);
        return this;
    }

    @Override
    public UpdateJobCommandStep1.UpdateJobCommandStep2 update(Integer retries, Long timeout) {
        this.getChangesetEnsureInitialized().retries(retries).timeout(timeout);
        return this;
    }

    @Override
    public UpdateJobCommandStep1.UpdateJobCommandStep2 updateRetries(int retries) {
        this.getChangesetEnsureInitialized().retries(retries);
        return this;
    }

    @Override
    public UpdateJobCommandStep1.UpdateJobCommandStep2 updateTimeout(long timeout) {
        this.getChangesetEnsureInitialized().timeout(timeout);
        return this;
    }

    @Override
    public UpdateJobCommandStep1.UpdateJobCommandStep2 updateTimeout(Duration timeout) {
        return this.updateTimeout(timeout.toMillis());
    }

    private io.camunda.client.protocol.rest.JobChangeset getChangesetEnsureInitialized() {
        io.camunda.client.protocol.rest.JobChangeset changeset = this.httpRequestObject.getChangeset();
        if (changeset == null) {
            changeset = new io.camunda.client.protocol.rest.JobChangeset();
            this.httpRequestObject.setChangeset(changeset);
        }
        return changeset;
    }
}

