/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.http;

import io.camunda.client.protocol.rest.ProblemDetail;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.Objects;

public interface ApiEntity<T> {
    public T response();

    public ProblemDetail problem();

    public ByteBuffer unknown();

    default public boolean isResponse() {
        return false;
    }

    default public boolean isProblem() {
        return false;
    }

    default public boolean isUnknown() {
        return false;
    }

    public static <T> ApiEntity<T> of(T response) {
        return new Response(response);
    }

    public static <T> ApiEntity<T> of(ProblemDetail error) {
        return new Error(error);
    }

    public static <T> ApiEntity<T> of(ByteBuffer body) {
        return new Unknown(body);
    }

    public static final class Response<T>
    implements ApiEntity<T> {
        private final T response;

        private Response(T response) {
            this.response = Objects.requireNonNull(response, "must specify a response");
        }

        @Override
        public T response() {
            return this.response;
        }

        @Override
        public ProblemDetail problem() {
            throw new NoSuchElementException("Expected to get a problem, but this is a successful response; use #response()");
        }

        @Override
        public ByteBuffer unknown() {
            throw new NoSuchElementException("Expected to get an unknown body, but this is a successful response; use #response()");
        }

        @Override
        public boolean isResponse() {
            return true;
        }
    }

    public static final class Error<T>
    implements ApiEntity<T> {
        private final ProblemDetail problem;

        private Error(ProblemDetail problem) {
            this.problem = Objects.requireNonNull(problem, "must specify a problem");
        }

        @Override
        public T response() {
            throw new NoSuchElementException("Expected to get a response, but this is a problem; use #problem()");
        }

        @Override
        public ProblemDetail problem() {
            return this.problem;
        }

        @Override
        public ByteBuffer unknown() {
            throw new NoSuchElementException("Expected to get an unknown body, but this is a problem; use #problem()");
        }

        @Override
        public boolean isProblem() {
            return true;
        }
    }

    public static final class Unknown<T>
    implements ApiEntity<T> {
        private final ByteBuffer body;

        private Unknown(ByteBuffer body) {
            this.body = body;
        }

        @Override
        public T response() {
            throw new NoSuchElementException("Expected to get a response, but this is an unknown body; use #unknown()");
        }

        @Override
        public ProblemDetail problem() {
            throw new NoSuchElementException("Expected to get a response, but this is an unknown body; use #unknown()");
        }

        @Override
        public ByteBuffer unknown() {
            return this.body;
        }

        @Override
        public boolean isUnknown() {
            return true;
        }
    }
}

