/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.response;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.camunda.client.api.response.DocumentMetadata;
import io.camunda.client.api.response.DocumentReferenceResponse;
import io.camunda.client.impl.response.DocumentMetadataImpl;
import io.camunda.client.protocol.rest.DocumentReference;
import java.io.IOException;

@JsonSerialize(using=DocumentReferenceSerializer.class)
@JsonDeserialize(using=DocumentReferenceDeserializer.class)
public class DocumentReferenceResponseImpl
implements DocumentReferenceResponse {
    private final DocumentReference documentReference;
    private final String documentId;
    private final String storeId;
    private final String contentHash;
    private final DocumentMetadata metadata;

    public DocumentReferenceResponseImpl(DocumentReference documentReference) {
        this.documentReference = documentReference;
        this.documentId = documentReference.getDocumentId();
        this.storeId = documentReference.getStoreId();
        this.contentHash = documentReference.getContentHash();
        this.metadata = new DocumentMetadataImpl(documentReference.getMetadata());
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    public String getStoreId() {
        return this.storeId;
    }

    @Override
    public String getContentHash() {
        return this.contentHash;
    }

    @Override
    public DocumentMetadata getMetadata() {
        return this.metadata;
    }

    public DocumentReference getDocumentReference() {
        return this.documentReference;
    }

    public static class DocumentReferenceDeserializer
    extends StdDeserializer<DocumentReferenceResponseImpl> {
        public DocumentReferenceDeserializer() {
            this(null);
        }

        public DocumentReferenceDeserializer(Class<DocumentReferenceResponseImpl> t) {
            super(t);
        }

        public DocumentReferenceResponseImpl deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            DocumentReference documentReference = (DocumentReference)p.getCodec().readValue(p, DocumentReference.class);
            return new DocumentReferenceResponseImpl(documentReference);
        }
    }

    public static class DocumentReferenceSerializer
    extends StdSerializer<DocumentReferenceResponseImpl> {
        public DocumentReferenceSerializer() {
            this(null);
        }

        public DocumentReferenceSerializer(Class<DocumentReferenceResponseImpl> t) {
            super(t);
        }

        public void serialize(DocumentReferenceResponseImpl value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeObject((Object)value.getDocumentReference());
        }
    }
}

