/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.request.DecisionInstanceSearchRequest;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.DecisionInstance;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.DecisionInstanceSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.DecisionInstanceFilter;
import io.camunda.client.protocol.rest.DecisionInstanceSearchQuery;
import io.camunda.client.protocol.rest.DecisionInstanceSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class DecisionInstanceSearchRequestImpl
extends TypedSearchRequestPropertyProvider<DecisionInstanceSearchQuery>
implements DecisionInstanceSearchRequest {
    private final DecisionInstanceSearchQuery request = new DecisionInstanceSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public DecisionInstanceSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public DecisionInstanceSearchRequest filter(io.camunda.client.api.search.filter.DecisionInstanceFilter value) {
        this.request.setFilter((DecisionInstanceFilter)DecisionInstanceSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public DecisionInstanceSearchRequest filter(Consumer<io.camunda.client.api.search.filter.DecisionInstanceFilter> fn) {
        return this.filter(SearchRequestBuilders.decisionInstanceFilter(fn));
    }

    @Override
    public DecisionInstanceSearchRequest sort(DecisionInstanceSort value) {
        this.request.setSort(SearchRequestSortMapper.toDecisionInstanceSearchQuerySortRequest((List)DecisionInstanceSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public DecisionInstanceSearchRequest sort(Consumer<DecisionInstanceSort> fn) {
        return this.sort(SearchRequestBuilders.decisionInstanceSort(fn));
    }

    @Override
    public DecisionInstanceSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)DecisionInstanceSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public DecisionInstanceSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected DecisionInstanceSearchQuery getSearchRequestProperty() {
        return this.request;
    }

    @Override
    public FinalSearchRequestStep<DecisionInstance> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<DecisionInstance>> send() {
        HttpCamundaFuture<SearchResponse<DecisionInstance>> result = new HttpCamundaFuture<SearchResponse<DecisionInstance>>();
        this.httpClient.post("/decision-instances/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), DecisionInstanceSearchQueryResult.class, resp -> SearchResponseMapper.toDecisionInstanceSearchResponse(resp, this.jsonMapper), result);
        return result;
    }
}

