/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.response;

import io.camunda.client.api.search.enums.JobKind;
import io.camunda.client.api.search.enums.JobState;
import io.camunda.client.api.search.enums.ListenerEventType;
import io.camunda.client.api.search.response.Job;
import io.camunda.client.impl.util.EnumUtil;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.JobSearchResult;
import java.time.OffsetDateTime;
import java.util.Map;

public class JobImpl
implements Job {
    private final Long jobKey;
    private final String type;
    private final String worker;
    private final JobState state;
    private final JobKind kind;
    private final ListenerEventType listenerEventType;
    private final Integer retries;
    private final Boolean isDenied;
    private final String deniedReason;
    private final Boolean hasFailedWithRetriesLeft;
    private final String errorCode;
    private final String errorMessage;
    private final Map<String, String> customerHeaders;
    private final OffsetDateTime deadline;
    private final OffsetDateTime endTime;
    private final String processDefinitionId;
    private final Long processDefinitionKey;
    private final Long processInstanceKey;
    private final String elementId;
    private final Long elementInstanceKey;
    private final String tenantId;

    public JobImpl(JobSearchResult item) {
        this.jobKey = ParseUtil.parseLongOrNull(item.getJobKey());
        this.type = item.getType();
        this.worker = item.getWorker();
        this.state = EnumUtil.convert(item.getState(), JobState.class);
        this.kind = EnumUtil.convert(item.getKind(), JobKind.class);
        this.listenerEventType = EnumUtil.convert(item.getListenerEventType(), ListenerEventType.class);
        this.retries = item.getRetries();
        this.isDenied = item.getIsDenied();
        this.deniedReason = item.getDeniedReason();
        this.hasFailedWithRetriesLeft = item.getHasFailedWithRetriesLeft();
        this.errorCode = item.getErrorCode();
        this.errorMessage = item.getErrorMessage();
        this.customerHeaders = item.getCustomHeaders();
        this.deadline = ParseUtil.parseOffsetDateTimeOrNull(item.getDeadline());
        this.endTime = ParseUtil.parseOffsetDateTimeOrNull(item.getEndTime());
        this.processDefinitionId = item.getProcessDefinitionId();
        this.processDefinitionKey = ParseUtil.parseLongOrNull(item.getProcessDefinitionKey());
        this.processInstanceKey = ParseUtil.parseLongOrNull(item.getProcessInstanceKey());
        this.elementId = item.getElementId();
        this.elementInstanceKey = ParseUtil.parseLongOrNull(item.getElementInstanceKey());
        this.tenantId = item.getTenantId();
    }

    @Override
    public Long getJobKey() {
        return this.jobKey;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getWorker() {
        return this.worker;
    }

    @Override
    public JobState getState() {
        return this.state;
    }

    @Override
    public JobKind getKind() {
        return this.kind;
    }

    @Override
    public ListenerEventType getListenerEventType() {
        return this.listenerEventType;
    }

    @Override
    public Integer getRetries() {
        return this.retries;
    }

    @Override
    public Boolean isDenied() {
        return this.isDenied;
    }

    @Override
    public String getDeniedReason() {
        return this.deniedReason;
    }

    @Override
    public Boolean hasFailedWithRetriesLeft() {
        return this.hasFailedWithRetriesLeft;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public Map<String, String> getCustomerHeaders() {
        return this.customerHeaders;
    }

    @Override
    public OffsetDateTime getDeadline() {
        return this.deadline;
    }

    @Override
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public Long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }
}

