/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.statistics.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.statistics.request.UsageMetricsStatisticsRequest;
import io.camunda.client.api.statistics.response.UsageMetricsStatistics;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.statistics.response.StatisticsResponseMapper;
import io.camunda.client.protocol.rest.UsageMetricsResponse;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class UsageMetricsStatisticsRequestImpl
implements UsageMetricsStatisticsRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final OffsetDateTime startTime;
    private final OffsetDateTime endTime;
    private String tenantId;
    private boolean withTenants = false;

    public UsageMetricsStatisticsRequestImpl(HttpClient httpClient, OffsetDateTime startTime, OffsetDateTime endTime) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    public FinalCommandStep<UsageMetricsStatistics> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UsageMetricsStatistics> send() {
        HttpCamundaFuture<UsageMetricsStatistics> result = new HttpCamundaFuture<UsageMetricsStatistics>();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("startTime", DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        queryParams.put("endTime", DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        if (this.withTenants) {
            queryParams.put("withTenants", String.valueOf(true));
        }
        if (this.tenantId != null) {
            queryParams.put("tenantId", this.tenantId);
        }
        this.httpClient.get("/system/usage-metrics", queryParams, this.httpRequestConfig.build(), UsageMetricsResponse.class, StatisticsResponseMapper::toUsageMetricsResponse, result);
        return result;
    }

    @Override
    public UsageMetricsStatisticsRequest withTenants(boolean withTenants) {
        this.withTenants = withTenants;
        return this;
    }

    @Override
    public UsageMetricsStatisticsRequest tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }
}

