/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.statistics.response;

import io.camunda.client.api.statistics.response.ProcessElementStatistics;
import io.camunda.client.api.statistics.response.UsageMetricsStatistics;
import io.camunda.client.api.statistics.response.UsageMetricsStatisticsItem;
import io.camunda.client.impl.statistics.response.ProcessElementStatisticsImpl;
import io.camunda.client.impl.statistics.response.UsageMetricsStatisticsImpl;
import io.camunda.client.impl.statistics.response.UsageMetricsStatisticsItemImpl;
import io.camunda.client.protocol.rest.ProcessDefinitionElementStatisticsQueryResult;
import io.camunda.client.protocol.rest.UsageMetricsResponse;
import io.camunda.client.protocol.rest.UsageMetricsResponseItem;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class StatisticsResponseMapper {
    public static List<ProcessElementStatistics> toProcessDefinitionStatisticsResponse(ProcessDefinitionElementStatisticsQueryResult response) {
        if (response.getItems() != null) {
            return response.getItems().stream().map(ProcessElementStatisticsImpl::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static UsageMetricsStatistics toUsageMetricsResponse(UsageMetricsResponse response) {
        Map<String, UsageMetricsStatisticsItem> tenants = null;
        if (response.getTenants() != null) {
            tenants = response.getTenants().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> StatisticsResponseMapper.toUsageMetricsResponseItem((UsageMetricsResponseItem)e.getValue())));
        }
        return new UsageMetricsStatisticsImpl(Optional.ofNullable(response.getProcessInstances()).orElse(0L), Optional.ofNullable(response.getDecisionInstances()).orElse(0L), Optional.ofNullable(response.getAssignees()).orElse(0L), Optional.ofNullable(response.getActiveTenants()).orElse(0L), tenants);
    }

    public static UsageMetricsStatisticsItem toUsageMetricsResponseItem(UsageMetricsResponseItem response) {
        return new UsageMetricsStatisticsItemImpl(Optional.ofNullable(response.getProcessInstances()).orElse(0L), Optional.ofNullable(response.getDecisionInstances()).orElse(0L), Optional.ofNullable(response.getAssignees()).orElse(0L));
    }
}

