/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"assignee", "dueDate", "followUpDate", "candidateUsers", "candidateGroups", "priority"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JobResultCorrections {
    public static final String JSON_PROPERTY_ASSIGNEE = "assignee";
    @Nullable
    private String assignee;
    public static final String JSON_PROPERTY_DUE_DATE = "dueDate";
    @Nullable
    private String dueDate;
    public static final String JSON_PROPERTY_FOLLOW_UP_DATE = "followUpDate";
    @Nullable
    private String followUpDate;
    public static final String JSON_PROPERTY_CANDIDATE_USERS = "candidateUsers";
    @Nullable
    private List<String> candidateUsers;
    public static final String JSON_PROPERTY_CANDIDATE_GROUPS = "candidateGroups";
    @Nullable
    private List<String> candidateGroups;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    @Nullable
    private Integer priority;

    public JobResultCorrections assignee(@Nullable String assignee) {
        this.assignee = assignee;
        return this;
    }

    @Nullable
    @JsonProperty(value="assignee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAssignee() {
        return this.assignee;
    }

    @JsonProperty(value="assignee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssignee(@Nullable String assignee) {
        this.assignee = assignee;
    }

    public JobResultCorrections dueDate(@Nullable String dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="dueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDueDate() {
        return this.dueDate;
    }

    @JsonProperty(value="dueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDueDate(@Nullable String dueDate) {
        this.dueDate = dueDate;
    }

    public JobResultCorrections followUpDate(@Nullable String followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="followUpDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFollowUpDate() {
        return this.followUpDate;
    }

    @JsonProperty(value="followUpDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFollowUpDate(@Nullable String followUpDate) {
        this.followUpDate = followUpDate;
    }

    public JobResultCorrections candidateUsers(@Nullable List<String> candidateUsers) {
        this.candidateUsers = candidateUsers;
        return this;
    }

    public JobResultCorrections addCandidateUsersItem(String candidateUsersItem) {
        if (this.candidateUsers == null) {
            this.candidateUsers = new ArrayList<String>();
        }
        this.candidateUsers.add(candidateUsersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="candidateUsers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCandidateUsers() {
        return this.candidateUsers;
    }

    @JsonProperty(value="candidateUsers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCandidateUsers(@Nullable List<String> candidateUsers) {
        this.candidateUsers = candidateUsers;
    }

    public JobResultCorrections candidateGroups(@Nullable List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
        return this;
    }

    public JobResultCorrections addCandidateGroupsItem(String candidateGroupsItem) {
        if (this.candidateGroups == null) {
            this.candidateGroups = new ArrayList<String>();
        }
        this.candidateGroups.add(candidateGroupsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="candidateGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCandidateGroups() {
        return this.candidateGroups;
    }

    @JsonProperty(value="candidateGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCandidateGroups(@Nullable List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
    }

    public JobResultCorrections priority(@Nullable Integer priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriority(@Nullable Integer priority) {
        this.priority = priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobResultCorrections jobResultCorrections = (JobResultCorrections)o;
        return Objects.equals(this.assignee, jobResultCorrections.assignee) && Objects.equals(this.dueDate, jobResultCorrections.dueDate) && Objects.equals(this.followUpDate, jobResultCorrections.followUpDate) && Objects.equals(this.candidateUsers, jobResultCorrections.candidateUsers) && Objects.equals(this.candidateGroups, jobResultCorrections.candidateGroups) && Objects.equals(this.priority, jobResultCorrections.priority);
    }

    public int hashCode() {
        return Objects.hash(this.assignee, this.dueDate, this.followUpDate, this.candidateUsers, this.candidateGroups, this.priority);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobResultCorrections {\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    followUpDate: ").append(this.toIndentedString(this.followUpDate)).append("\n");
        sb.append("    candidateUsers: ").append(this.toIndentedString(this.candidateUsers)).append("\n");
        sb.append("    candidateGroups: ").append(this.toIndentedString(this.candidateGroups)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAssignee() != null) {
            try {
                joiner.add(String.format("%sassignee%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAssignee()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDueDate() != null) {
            try {
                joiner.add(String.format("%sdueDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDueDate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFollowUpDate() != null) {
            try {
                joiner.add(String.format("%sfollowUpDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFollowUpDate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCandidateUsers() != null) {
            for (i = 0; i < this.getCandidateUsers().size(); ++i) {
                try {
                    joiner.add(String.format("%scandidateUsers%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getCandidateUsers().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getCandidateGroups() != null) {
            for (i = 0; i < this.getCandidateGroups().size(); ++i) {
                try {
                    joiner.add(String.format("%scandidateGroups%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getCandidateGroups().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getPriority() != null) {
            try {
                joiner.add(String.format("%spriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPriority()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

