/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api;

import io.camunda.client.CamundaClient;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.spring.event.CamundaClientClosingSpringEvent;
import io.camunda.client.spring.event.CamundaClientCreatedSpringEvent;
import io.camunda.process.test.api.CamundaAssert;
import io.camunda.process.test.api.CamundaProcessTestContext;
import io.camunda.process.test.api.coverage.ProcessCoverage;
import io.camunda.process.test.api.coverage.ProcessCoverageBuilder;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.client.CamundaManagementClient;
import io.camunda.process.test.impl.configuration.CamundaProcessTestRuntimeConfiguration;
import io.camunda.process.test.impl.configuration.CoverageReportConfiguration;
import io.camunda.process.test.impl.containers.CamundaContainer;
import io.camunda.process.test.impl.extension.CamundaProcessTestContextImpl;
import io.camunda.process.test.impl.proxy.CamundaClientProxy;
import io.camunda.process.test.impl.proxy.CamundaProcessTestContextProxy;
import io.camunda.process.test.impl.proxy.ZeebeClientProxy;
import io.camunda.process.test.impl.runtime.CamundaProcessTestContainerRuntime;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntime;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntimeBuilder;
import io.camunda.process.test.impl.runtime.CamundaSpringProcessTestRuntimeBuilder;
import io.camunda.process.test.impl.testresult.CamundaProcessTestResultCollector;
import io.camunda.process.test.impl.testresult.CamundaProcessTestResultPrinter;
import io.camunda.process.test.impl.testresult.ProcessTestResult;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.spring.client.event.ZeebeClientClosingEvent;
import io.camunda.zeebe.spring.client.event.ZeebeClientCreatedEvent;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.Ordered;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;

public class CamundaProcessTestExecutionListener
implements TestExecutionListener,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(CamundaProcessTestExecutionListener.class);
    private final CamundaProcessTestRuntimeBuilder containerRuntimeBuilder;
    private final CamundaProcessTestResultPrinter processTestResultPrinter;
    private final ProcessCoverageBuilder processCoverageBuilder;
    private final List<AutoCloseable> createdClients = new ArrayList<AutoCloseable>();
    private ProcessCoverage processCoverage;
    private CamundaProcessTestRuntime runtime;
    private CamundaProcessTestResultCollector processTestResultCollector;
    private CamundaProcessTestContext camundaProcessTestContext;
    private CamundaManagementClient camundaManagementClient;
    private CamundaClient client;
    private ZeebeClient zeebeClient;

    public CamundaProcessTestExecutionListener() {
        this(CamundaProcessTestContainerRuntime.newBuilder(), ProcessCoverage.newBuilder(), arg_0 -> ((Logger)LOG).info(arg_0));
    }

    CamundaProcessTestExecutionListener(CamundaProcessTestRuntimeBuilder containerRuntimeBuilder, ProcessCoverageBuilder processCoverageBuilder, Consumer<String> testResultPrintStream) {
        this.containerRuntimeBuilder = containerRuntimeBuilder;
        this.processCoverageBuilder = processCoverageBuilder.printStream(testResultPrintStream);
        this.processTestResultPrinter = new CamundaProcessTestResultPrinter(testResultPrintStream);
    }

    public void beforeTestClass(TestContext testContext) {
        CamundaProcessTestRuntimeConfiguration runtimeConfiguration = (CamundaProcessTestRuntimeConfiguration)testContext.getApplicationContext().getBean(CamundaProcessTestRuntimeConfiguration.class);
        JsonMapper jsonMapper = (JsonMapper)testContext.getApplicationContext().getBean(JsonMapper.class);
        io.camunda.zeebe.client.api.JsonMapper zeebeJsonMapper = (io.camunda.zeebe.client.api.JsonMapper)testContext.getApplicationContext().getBean(io.camunda.zeebe.client.api.JsonMapper.class);
        this.runtime = this.buildRuntime(runtimeConfiguration);
        this.runtime.start();
        this.camundaManagementClient = this.createManagementClient(runtimeConfiguration);
        this.camundaProcessTestContext = new CamundaProcessTestContextImpl(this.runtime, this.createdClients::add, this.camundaManagementClient, CamundaAssert.getAwaitBehavior(), jsonMapper, zeebeJsonMapper);
        CoverageReportConfiguration coverageReportConfiguration = runtimeConfiguration.getCoverage();
        this.processCoverage = this.processCoverageBuilder.testClass(testContext.getTestClass()).dataSource(() -> new CamundaDataSource(this.camundaProcessTestContext.createClient())).reportDirectory(coverageReportConfiguration.getReportDirectory()).excludeProcessDefinitionIds(coverageReportConfiguration.getExcludedProcesses()).build();
        this.initializeJsonMapper(jsonMapper, zeebeJsonMapper);
    }

    public void beforeTestMethod(TestContext testContext) {
        this.client = CamundaProcessTestExecutionListener.createClient(this.camundaProcessTestContext);
        this.zeebeClient = CamundaProcessTestExecutionListener.createZeebeClient(this.camundaProcessTestContext);
        ((CamundaClientProxy)testContext.getApplicationContext().getBean(CamundaClientProxy.class)).setClient(this.client);
        ((ZeebeClientProxy)testContext.getApplicationContext().getBean(ZeebeClientProxy.class)).setClient(this.zeebeClient);
        ((CamundaProcessTestContextProxy)testContext.getApplicationContext().getBean(CamundaProcessTestContextProxy.class)).setContext(this.camundaProcessTestContext);
        testContext.getApplicationContext().publishEvent((ApplicationEvent)new CamundaClientCreatedSpringEvent((Object)this, this.client));
        testContext.getApplicationContext().publishEvent((ApplicationEvent)new ZeebeClientCreatedEvent((Object)this, this.zeebeClient));
        CamundaDataSource dataSource = new CamundaDataSource(this.client);
        CamundaAssert.initialize((CamundaDataSource)dataSource);
        this.processTestResultCollector = new CamundaProcessTestResultCollector(dataSource);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        if (this.runtime == null) {
            return;
        }
        try {
            this.processCoverage.collectTestRunCoverage(testContext.getTestMethod().getName());
        }
        catch (Throwable t) {
            LOG.warn("Failed to collect test process coverage, skipping.", t);
        }
        if (CamundaProcessTestExecutionListener.isTestFailed(testContext)) {
            this.printTestResults();
        }
        CamundaAssert.reset();
        testContext.getApplicationContext().publishEvent((ApplicationEvent)new CamundaClientClosingSpringEvent((Object)this, this.client));
        testContext.getApplicationContext().publishEvent((ApplicationEvent)new ZeebeClientClosingEvent((Object)this, this.zeebeClient));
        this.closeCreatedClients();
        ((CamundaClientProxy)testContext.getApplicationContext().getBean(CamundaClientProxy.class)).removeClient();
        ((ZeebeClientProxy)testContext.getApplicationContext().getBean(ZeebeClientProxy.class)).removeClient();
        ((CamundaProcessTestContextProxy)testContext.getApplicationContext().getBean(CamundaProcessTestContextProxy.class)).removeContext();
        this.resetRuntimeClock();
        this.deleteRuntimeData();
    }

    public void afterTestClass(TestContext testContext) throws Exception {
        if (this.runtime == null) {
            return;
        }
        try {
            this.processCoverage.reportCoverage();
        }
        catch (Throwable t) {
            LOG.warn("Failed to report process coverage, skipping.", t);
        }
        this.runtime.close();
    }

    private void initializeJsonMapper(JsonMapper jsonMapper, io.camunda.zeebe.client.api.JsonMapper zeebeJsonMapper) {
        if (jsonMapper != null) {
            CamundaAssert.setJsonMapper((JsonMapper)jsonMapper);
        } else if (zeebeJsonMapper != null) {
            CamundaAssert.setJsonMapper((io.camunda.zeebe.client.api.JsonMapper)zeebeJsonMapper);
        }
    }

    private CamundaManagementClient createManagementClient(CamundaProcessTestRuntimeConfiguration runtimeConfiguration) {
        if (runtimeConfiguration.isMultiTenancyEnabled()) {
            return CamundaManagementClient.createAuthenticatedClient((URI)this.runtime.getCamundaMonitoringApiAddress(), (URI)this.runtime.getCamundaRestApiAddress(), (String)CamundaContainer.MultiTenancyConfiguration.getBasicAuthCredentials());
        }
        return CamundaManagementClient.createClient((URI)this.runtime.getCamundaMonitoringApiAddress(), (URI)this.runtime.getCamundaRestApiAddress());
    }

    private void printTestResults() {
        try {
            ProcessTestResult testResult = this.processTestResultCollector.collect();
            this.processTestResultPrinter.print(testResult);
        }
        catch (Throwable t) {
            LOG.warn("Failed to collect test results, skipping.", t);
        }
    }

    private void deleteRuntimeData() {
        try {
            LOG.debug("Deleting the runtime data");
            Instant startTime = Instant.now();
            this.camundaManagementClient.purgeCluster();
            Instant endTime = Instant.now();
            Duration duration = Duration.between(startTime, endTime);
            LOG.debug("Runtime data deleted in {}", (Object)duration);
        }
        catch (Throwable t) {
            LOG.warn("Failed to delete the runtime data, skipping. Check the runtime for details. Note that a dirty runtime may cause failures in other test cases.", t);
        }
    }

    private void resetRuntimeClock() {
        try {
            LOG.debug("Resetting the time");
            this.camundaManagementClient.resetTime();
            LOG.debug("Time reset");
        }
        catch (Throwable t) {
            LOG.warn("Failed to reset the time, skipping. Check the runtime for details. Note that a dirty runtime may cause failures in other test cases.", t);
        }
    }

    private void closeCreatedClients() {
        for (AutoCloseable client : this.createdClients) {
            try {
                client.close();
            }
            catch (Exception e) {
                LOG.debug("Failed to close client, continue.", (Throwable)e);
            }
        }
    }

    private CamundaProcessTestRuntime buildRuntime(CamundaProcessTestRuntimeConfiguration runtimeConfiguration) {
        return CamundaSpringProcessTestRuntimeBuilder.buildRuntime(this.containerRuntimeBuilder, runtimeConfiguration);
    }

    private static CamundaClient createClient(CamundaProcessTestContext camundaProcessTestContext) {
        return camundaProcessTestContext.createClient();
    }

    private static ZeebeClient createZeebeClient(CamundaProcessTestContext camundaProcessTestContext) {
        return camundaProcessTestContext.createZeebeClient();
    }

    private static boolean isTestFailed(TestContext testContext) {
        return testContext.getTestException() != null;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

