/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.proxy;

import io.camunda.process.test.impl.proxy.AbstractInvocationHandler;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractClientProxy<T>
extends AbstractInvocationHandler {
    private T delegate;

    public void setClient(T client) {
        this.delegate = client;
    }

    public void removeClient() {
        this.delegate = null;
    }

    @Override
    protected Object handleInvocation(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
        if (this.delegate == null) {
            String delegateClassName = this.getDelegateClass().getSimpleName();
            throw new RuntimeException("Cannot invoke %s on %s, as %s is currently not initialized. Maybe you run outside of a testcase?".formatted(method, delegateClassName, delegateClassName));
        }
        return method.invoke(this.delegate, args);
    }

    protected abstract Class<T> getDelegateClass();
}

