/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.jobhandling;

import io.camunda.client.annotation.value.JobWorkerValue;
import io.camunda.client.api.command.FailJobCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.ThrowErrorCommandStep1;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.response.FailJobResponse;
import io.camunda.client.api.response.ThrowErrorResponse;
import io.camunda.client.api.worker.JobClient;
import io.camunda.client.exception.BpmnError;
import io.camunda.client.exception.JobError;
import io.camunda.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.client.jobhandling.CommandWrapper;
import io.camunda.client.jobhandling.JobExceptionHandlingStrategy;
import io.camunda.client.jobhandling.JobHandlingUtil;
import io.camunda.client.metrics.MetricsRecorder;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJobExceptionHandlingStrategy
implements JobExceptionHandlingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJobExceptionHandlingStrategy.class);
    private final CommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final MetricsRecorder metricsRecorder;

    public DefaultJobExceptionHandlingStrategy(CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, MetricsRecorder metricsRecorder) {
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.metricsRecorder = metricsRecorder;
    }

    private CommandWrapper createCommandWrapper(FinalCommandStep<?> command, ActivatedJob job, JobWorkerValue workerValue) {
        return new CommandWrapper(command, job, this.commandExceptionHandlingStrategy, this.metricsRecorder, workerValue.getMaxRetries());
    }

    @Override
    public void handleException(Exception exception, JobExceptionHandlingStrategy.ExceptionHandlingContext context) throws Exception {
        if (exception instanceof JobError) {
            JobError jobError = (JobError)exception;
            LOG.trace("Caught job error on {}", (Object)context.job());
            CommandWrapper command = this.createCommandWrapper(this.createFailJobCommand(context.jobClient(), context.job(), jobError), context.job(), context.jobWorkerValue());
            command.executeAsyncWithMetrics("camunda.job.invocations", "failed", context.job().getType());
        } else if (exception instanceof BpmnError) {
            BpmnError bpmnError = (BpmnError)exception;
            LOG.trace("Caught BPMN error on {}", (Object)context.job());
            CommandWrapper command = this.createCommandWrapper(this.createThrowErrorCommand(context.jobClient(), context.job(), bpmnError), context.job(), context.jobWorkerValue());
            command.executeAsyncWithMetrics("camunda.job.invocations", "bpmn-error", context.job().getType());
        } else {
            this.metricsRecorder.increase("camunda.job.invocations", "failed", context.job().getType());
            throw exception;
        }
    }

    private FinalCommandStep<ThrowErrorResponse> createThrowErrorCommand(JobClient jobClient, ActivatedJob job, BpmnError bpmnError) {
        ThrowErrorCommandStep1.ThrowErrorCommandStep2 command = jobClient.newThrowErrorCommand(job.getKey()).errorCode(bpmnError.getErrorCode()).errorMessage(bpmnError.getErrorMessage());
        return (FinalCommandStep)JobHandlingUtil.applyVariables(bpmnError.getVariables(), command);
    }

    private FinalCommandStep<FailJobResponse> createFailJobCommand(JobClient jobClient, ActivatedJob job, JobError jobError) {
        int retries = jobError.getRetries() == null ? job.getRetries() - 1 : jobError.getRetries();
        String errorMessage = JobHandlingUtil.createErrorMessage(jobError);
        Duration backoff = jobError.getRetryBackoff() == null ? Duration.ZERO : jobError.getRetryBackoff();
        FailJobCommandStep1.FailJobCommandStep2 command = jobClient.newFailCommand(job.getKey()).retries(retries).errorMessage(errorMessage).retryBackoff(backoff);
        return (FinalCommandStep)JobHandlingUtil.applyVariables(jobError.getVariables(), command);
    }
}

