/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.spring.properties;

import io.camunda.client.impl.CamundaClientBuilderImpl;
import io.camunda.client.impl.util.ClientPropertiesValidationUtils;
import io.camunda.client.spring.properties.CamundaClientAuthProperties;
import io.camunda.client.spring.properties.CamundaClientCloudProperties;
import io.camunda.client.spring.properties.CamundaClientDeploymentProperties;
import io.camunda.client.spring.properties.CamundaClientWorkerProperties;
import java.net.URI;
import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(value="camunda.client")
public class CamundaClientProperties {
    private boolean enabled = true;
    private ClientMode mode;
    @NestedConfigurationProperty
    private CamundaClientCloudProperties cloud = new CamundaClientCloudProperties();
    @NestedConfigurationProperty
    private CamundaClientAuthProperties auth = new CamundaClientAuthProperties();
    private Integer executionThreads = 1;
    private Duration messageTimeToLive = CamundaClientBuilderImpl.DEFAULT_MESSAGE_TTL;
    private DataSize maxMessageSize = DataSize.ofBytes((long)0x500000L);
    private DataSize maxMetadataSize = DataSize.ofBytes((long)16384L);
    private String caCertificatePath;
    private Duration keepAlive = CamundaClientBuilderImpl.DEFAULT_KEEP_ALIVE;
    private String overrideAuthority;
    @NestedConfigurationProperty
    private CamundaClientWorkerProperties worker = new CamundaClientWorkerProperties();
    private boolean preferRestOverGrpc = true;
    private URI grpcAddress = CamundaClientBuilderImpl.DEFAULT_GRPC_ADDRESS;
    private URI restAddress = CamundaClientBuilderImpl.DEFAULT_REST_ADDRESS;
    @NestedConfigurationProperty
    private CamundaClientDeploymentProperties deployment = new CamundaClientDeploymentProperties();
    private String tenantId = "<default>";
    private Duration requestTimeout = CamundaClientBuilderImpl.DEFAULT_REQUEST_TIMEOUT;
    private Duration requestTimeoutOffset = CamundaClientBuilderImpl.DEFAULT_REQUEST_TIMEOUT_OFFSET;

    public CamundaClientCloudProperties getCloud() {
        return this.cloud;
    }

    public void setCloud(CamundaClientCloudProperties cloud) {
        this.cloud = cloud;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Duration getRequestTimeoutOffset() {
        return this.requestTimeoutOffset;
    }

    public void setRequestTimeoutOffset(Duration requestTimeoutOffset) {
        this.requestTimeoutOffset = requestTimeoutOffset;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public CamundaClientWorkerProperties getWorker() {
        return this.worker;
    }

    public void setWorker(CamundaClientWorkerProperties worker) {
        this.worker = worker;
    }

    public Integer getExecutionThreads() {
        return this.executionThreads;
    }

    public void setExecutionThreads(Integer executionThreads) {
        this.executionThreads = executionThreads;
    }

    public Duration getMessageTimeToLive() {
        return this.messageTimeToLive;
    }

    public void setMessageTimeToLive(Duration messageTimeToLive) {
        this.messageTimeToLive = messageTimeToLive;
    }

    public String getCaCertificatePath() {
        return this.caCertificatePath;
    }

    public void setCaCertificatePath(String caCertificatePath) {
        this.caCertificatePath = caCertificatePath;
    }

    public Duration getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Duration keepAlive) {
        this.keepAlive = keepAlive;
    }

    public String getOverrideAuthority() {
        return this.overrideAuthority;
    }

    public void setOverrideAuthority(String overrideAuthority) {
        this.overrideAuthority = overrideAuthority;
    }

    public DataSize getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(DataSize maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public DataSize getMaxMetadataSize() {
        return this.maxMetadataSize;
    }

    public void setMaxMetadataSize(DataSize maxMetadataSize) {
        this.maxMetadataSize = maxMetadataSize;
    }

    public boolean getPreferRestOverGrpc() {
        return this.preferRestOverGrpc;
    }

    public void setPreferRestOverGrpc(boolean preferRestOverGrpc) {
        this.preferRestOverGrpc = preferRestOverGrpc;
    }

    public URI getGrpcAddress() {
        return this.grpcAddress;
    }

    public void setGrpcAddress(URI grpcAddress) {
        ClientPropertiesValidationUtils.checkIfUriIsAbsolute((URI)grpcAddress, (String)"grpcAddress");
        this.grpcAddress = grpcAddress;
    }

    public URI getRestAddress() {
        return this.restAddress;
    }

    public void setRestAddress(URI restAddress) {
        ClientPropertiesValidationUtils.checkIfUriIsAbsolute((URI)restAddress, (String)"restAddress");
        this.restAddress = restAddress;
    }

    public CamundaClientDeploymentProperties getDeployment() {
        return this.deployment;
    }

    public void setDeployment(CamundaClientDeploymentProperties deployment) {
        this.deployment = deployment;
    }

    public ClientMode getMode() {
        return this.mode;
    }

    public void setMode(ClientMode mode) {
        this.mode = mode;
    }

    public CamundaClientAuthProperties getAuth() {
        return this.auth;
    }

    public void setAuth(CamundaClientAuthProperties auth) {
        this.auth = auth;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return "CamundaClientProperties{enabled=" + this.enabled + ", mode=" + String.valueOf((Object)this.mode) + ", cloud=" + String.valueOf(this.cloud) + ", auth=" + String.valueOf(this.auth) + ", executionThreads=" + this.executionThreads + ", messageTimeToLive=" + String.valueOf(this.messageTimeToLive) + ", maxMessageSize=" + String.valueOf(this.maxMessageSize) + ", maxMetadataSize=" + String.valueOf(this.maxMetadataSize) + ", caCertificatePath='" + this.caCertificatePath + "', keepAlive=" + String.valueOf(this.keepAlive) + ", overrideAuthority='" + this.overrideAuthority + "', worker=" + String.valueOf(this.worker) + ", preferRestOverGrpc=" + this.preferRestOverGrpc + ", grpcAddress=" + String.valueOf(this.grpcAddress) + ", restAddress=" + String.valueOf(this.restAddress) + ", deployment=" + String.valueOf(this.deployment) + ", tenantId='" + this.tenantId + "', requestTimeout=" + String.valueOf(this.requestTimeout) + "}";
    }

    public static enum ClientMode {
        selfManaged,
        saas;

    }
}

