/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import io.camunda.zeebe.client.api.response.UserTaskProperties;
import io.camunda.zeebe.client.impl.util.ParseUtil;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public final class UserTaskPropertiesImpl
implements UserTaskProperties {
    private final String action;
    private final String assignee;
    private final List<String> candidateGroups;
    private final List<String> candidateUsers;
    private final List<String> changedAttributes;
    private final String dueDate;
    private final String followUpDate;
    private final Long formKey;
    private final Integer priority;
    private final Long userTaskKey;

    public UserTaskPropertiesImpl(GatewayOuterClass.UserTaskProperties props) {
        this.action = UserTaskPropertiesImpl.orNull(() -> ((GatewayOuterClass.UserTaskProperties)props).hasAction(), () -> ((GatewayOuterClass.UserTaskProperties)props).getAction());
        this.assignee = UserTaskPropertiesImpl.orNull(() -> ((GatewayOuterClass.UserTaskProperties)props).hasAssignee(), () -> ((GatewayOuterClass.UserTaskProperties)props).getAssignee());
        this.candidateGroups = props.getCandidateGroupsList();
        this.candidateUsers = props.getCandidateUsersList();
        this.changedAttributes = props.getChangedAttributesList();
        this.dueDate = UserTaskPropertiesImpl.orNull(() -> ((GatewayOuterClass.UserTaskProperties)props).hasDueDate(), () -> ((GatewayOuterClass.UserTaskProperties)props).getDueDate());
        this.followUpDate = UserTaskPropertiesImpl.orNull(() -> ((GatewayOuterClass.UserTaskProperties)props).hasFollowUpDate(), () -> ((GatewayOuterClass.UserTaskProperties)props).getFollowUpDate());
        this.formKey = UserTaskPropertiesImpl.orNull(() -> ((GatewayOuterClass.UserTaskProperties)props).hasFormKey(), () -> ((GatewayOuterClass.UserTaskProperties)props).getFormKey());
        this.priority = UserTaskPropertiesImpl.orNull(() -> ((GatewayOuterClass.UserTaskProperties)props).hasPriority(), () -> ((GatewayOuterClass.UserTaskProperties)props).getPriority());
        this.userTaskKey = UserTaskPropertiesImpl.orNull(() -> ((GatewayOuterClass.UserTaskProperties)props).hasUserTaskKey(), () -> ((GatewayOuterClass.UserTaskProperties)props).getUserTaskKey());
    }

    public UserTaskPropertiesImpl(io.camunda.zeebe.client.protocol.rest.UserTaskProperties props) {
        this.action = props.getAction();
        this.assignee = props.getAssignee();
        this.candidateGroups = props.getCandidateGroups();
        this.candidateUsers = props.getCandidateUsers();
        this.changedAttributes = props.getChangedAttributes();
        this.dueDate = props.getDueDate();
        this.followUpDate = props.getFollowUpDate();
        this.formKey = ParseUtil.parseLongOrNull(props.getFormKey());
        this.priority = props.getPriority();
        this.userTaskKey = ParseUtil.parseLongOrNull(props.getUserTaskKey());
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public List<String> getCandidateGroups() {
        return this.candidateGroups;
    }

    @Override
    public List<String> getCandidateUsers() {
        return this.candidateUsers;
    }

    @Override
    public List<String> getChangedAttributes() {
        return this.changedAttributes;
    }

    @Override
    public String getDueDate() {
        return this.dueDate;
    }

    @Override
    public String getFollowUpDate() {
        return this.followUpDate;
    }

    @Override
    public Long getFormKey() {
        return this.formKey;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public Long getUserTaskKey() {
        return this.userTaskKey;
    }

    private static <T> T orNull(BooleanSupplier hasValue, Supplier<T> getter) {
        return hasValue.getAsBoolean() ? (T)getter.get() : null;
    }
}

