/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"tenantId", "formId", "schema", "version", "formKey"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FormResult {
    public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
    @Nullable
    private String tenantId;
    public static final String JSON_PROPERTY_FORM_ID = "formId";
    @Nullable
    private String formId;
    public static final String JSON_PROPERTY_SCHEMA = "schema";
    @Nullable
    private Object schema;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private Long version;
    public static final String JSON_PROPERTY_FORM_KEY = "formKey";
    @Nullable
    private String formKey;

    public FormResult tenantId(@Nullable String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenantId(@Nullable String tenantId) {
        this.tenantId = tenantId;
    }

    public FormResult formId(@Nullable String formId) {
        this.formId = formId;
        return this;
    }

    @Nullable
    @JsonProperty(value="formId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFormId() {
        return this.formId;
    }

    @JsonProperty(value="formId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormId(@Nullable String formId) {
        this.formId = formId;
    }

    public FormResult schema(@Nullable Object schema) {
        this.schema = schema;
        return this;
    }

    @Nullable
    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchema(@Nullable Object schema) {
        this.schema = schema;
    }

    public FormResult version(@Nullable Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable Long version) {
        this.version = version;
    }

    public FormResult formKey(@Nullable String formKey) {
        this.formKey = formKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="formKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFormKey() {
        return this.formKey;
    }

    @JsonProperty(value="formKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormKey(@Nullable String formKey) {
        this.formKey = formKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormResult formResult = (FormResult)o;
        return Objects.equals(this.tenantId, formResult.tenantId) && Objects.equals(this.formId, formResult.formId) && Objects.equals(this.schema, formResult.schema) && Objects.equals(this.version, formResult.version) && Objects.equals(this.formKey, formResult.formKey);
    }

    public int hashCode() {
        return Objects.hash(this.tenantId, this.formId, this.schema, this.version, this.formKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormResult {\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    formId: ").append(this.toIndentedString(this.formId)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    formKey: ").append(this.toIndentedString(this.formKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTenantId() != null) {
            try {
                joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFormId() != null) {
            try {
                joiner.add(String.format("%sformId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFormId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSchema() != null) {
            try {
                joiner.add(String.format("%sschema%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSchema()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getVersion() != null) {
            try {
                joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVersion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFormKey() != null) {
            try {
                joiner.add(String.format("%sformKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFormKey()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

