/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.ecr;

import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.access.ecr.AwsSigner4Request;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.codehaus.plexus.util.StringUtils;

class AwsSigner4 {
    private static final char[] HEXITS = "0123456789abcdef".toCharArray();
    private final String service;
    private final String region;

    AwsSigner4(String region, String service) {
        this.region = region;
        this.service = service;
    }

    void sign(HttpRequest request, AuthConfig credentials, Date signingTime) {
        AwsSigner4Request sr = new AwsSigner4Request(this.region, this.service, request, signingTime);
        if (!request.containsHeader("X-Amz-Date")) {
            request.addHeader("X-Amz-Date", sr.getSigningDateTime());
        }
        request.addHeader("Authorization", this.task4(sr, credentials));
        String securityToken = credentials.getAuth();
        if (StringUtils.isNotEmpty((String)securityToken)) {
            request.addHeader("X-Amz-Security-Token", securityToken);
        }
    }

    String task1(AwsSigner4Request sr) {
        StringBuilder sb = new StringBuilder(sr.getMethod()).append('\n').append(sr.getUri().getRawPath()).append('\n').append(this.getCanonicalQuery(sr.getUri())).append('\n').append(sr.getCanonicalHeaders()).append('\n').append(sr.getSignedHeaders()).append('\n');
        AwsSigner4.hexEncode(sb, AwsSigner4.sha256(sr.getBytes()));
        return sb.toString();
    }

    String task2(AwsSigner4Request sr) {
        StringBuilder sb = new StringBuilder("AWS4-HMAC-SHA256\n").append(sr.getSigningDateTime()).append('\n').append(sr.getScope()).append('\n');
        AwsSigner4.hexEncode(sb, AwsSigner4.sha256(this.task1(sr)));
        return sb.toString();
    }

    final byte[] task3(AwsSigner4Request sr, AuthConfig credentials) {
        return AwsSigner4.hmacSha256(AwsSigner4.getSigningKey(sr, credentials), this.task2(sr));
    }

    private static byte[] getSigningKey(AwsSigner4Request sr, AuthConfig credentials) {
        byte[] kSecret = ("AWS4" + credentials.getPassword()).getBytes(StandardCharsets.UTF_8);
        byte[] kDate = AwsSigner4.hmacSha256(kSecret, sr.getSigningDate());
        byte[] kRegion = AwsSigner4.hmacSha256(kDate, sr.getRegion());
        byte[] kService = AwsSigner4.hmacSha256(kRegion, sr.getService());
        return AwsSigner4.hmacSha256(kService, "aws4_request");
    }

    String task4(AwsSigner4Request sr, AuthConfig credentials) {
        StringBuilder sb = new StringBuilder("AWS4-HMAC-SHA256 Credential=").append(credentials.getUsername()).append('/').append(sr.getScope()).append(", SignedHeaders=").append(sr.getSignedHeaders()).append(", Signature=");
        AwsSigner4.hexEncode(sb, this.task3(sr, credentials));
        return sb.toString();
    }

    private String getCanonicalQuery(URI uri) {
        String query = uri.getQuery();
        if (query == null || query.isEmpty()) {
            return "";
        }
        List params = URLEncodedUtils.parse((String)query, (Charset)StandardCharsets.UTF_8);
        Collections.sort(params, new Comparator<NameValuePair>(){

            @Override
            public int compare(NameValuePair l, NameValuePair r) {
                return l.getName().compareToIgnoreCase(r.getName());
            }
        });
        return URLEncodedUtils.format((Iterable)params, (Charset)StandardCharsets.UTF_8);
    }

    static void hexEncode(StringBuilder dst, byte[] src) {
        for (byte aSrc : src) {
            int v = aSrc & 0xFF;
            dst.append(HEXITS[v >>> 4]);
            dst.append(HEXITS[v & 0xF]);
        }
    }

    private static byte[] hmacSha256(byte[] key, String value) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(value.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e.getMessage(), e);
        }
    }

    private static byte[] sha256(String string) {
        return AwsSigner4.sha256(string.getBytes(StandardCharsets.UTF_8));
    }

    private static byte[] sha256(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(bytes);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e.getMessage(), e);
        }
    }
}

