/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core.page;

import com.ruiyun.jvppeteer.core.browser.Browser;
import com.ruiyun.jvppeteer.core.browser.BrowserContext;
import com.ruiyun.jvppeteer.core.page.Page;
import com.ruiyun.jvppeteer.core.page.TargetInfo;
import com.ruiyun.jvppeteer.core.page.TaskQueue;
import com.ruiyun.jvppeteer.core.page.Worker;
import com.ruiyun.jvppeteer.events.Events;
import com.ruiyun.jvppeteer.options.Viewport;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.transport.factory.SessionFactory;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class Target {
    private Boolean initializedPromise;
    private CountDownLatch initializedCountDown;
    private TargetInfo targetInfo;
    private BrowserContext browserContext;
    private boolean ignoreHTTPSErrors;
    private Viewport viewport;
    private TaskQueue<String> screenshotTaskQueue;
    private String targetId;
    private Page pagePromise;
    private Worker workerPromise;
    private boolean isInitialized;
    private SessionFactory sessionFactory;
    private String sessionId;
    private CountDownLatch isClosedPromiseLatch;

    public Target() {
    }

    public Target(TargetInfo targetInfo, BrowserContext browserContext, SessionFactory sessionFactory, boolean ignoreHTTPSErrors, Viewport defaultViewport, TaskQueue<String> screenshotTaskQueue) {
        this.targetInfo = targetInfo;
        this.browserContext = browserContext;
        this.targetId = targetInfo.getTargetId();
        this.sessionFactory = sessionFactory;
        this.ignoreHTTPSErrors = ignoreHTTPSErrors;
        this.viewport = defaultViewport;
        this.screenshotTaskQueue = screenshotTaskQueue;
        this.pagePromise = null;
        this.workerPromise = null;
        this.isClosedPromiseLatch = new CountDownLatch(1);
        this.isInitialized = !"page".equals(this.targetInfo.getType()) || !StringUtil.isEmpty(this.targetInfo.getUrl());
        this.initializedPromise = this.isInitialized ? Boolean.valueOf(this.initializedCallback(true)) : Boolean.valueOf(true);
    }

    public CDPSession createCDPSession() {
        return this.sessionFactory.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Worker worker() {
        if (!"service_worker".equals(this.targetInfo.getType()) && !"shared_worker".equals(this.targetInfo.getType())) {
            return null;
        }
        if (this.workerPromise == null) {
            Target target = this;
            synchronized (target) {
                if (this.workerPromise == null) {
                    CDPSession client = this.sessionFactory.create();
                    this.workerPromise = new Worker(client, this.targetInfo.getUrl(), (arg0, arg1, arg2) -> {}, arg -> {});
                }
            }
        }
        return this.workerPromise;
    }

    public void closedCallback() {
        if (this.pagePromise != null) {
            this.pagePromise.emit(Events.PAGE_CLOSE.getName(), null);
            this.pagePromise.setClosed(true);
        }
        this.isClosedPromiseLatch.countDown();
    }

    public Page page() {
        String type = this.targetInfo.getType();
        if (("page".equals(type) || "background_page".equals(type)) && this.pagePromise == null) {
            try {
                this.pagePromise = Page.create(this.sessionFactory.create(), this, this.ignoreHTTPSErrors, this.viewport, this.screenshotTaskQueue);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return this.pagePromise;
    }

    public String type() {
        String type = this.targetInfo.getType();
        if ("page".equals(type) || "background_page".equals(type) || "service_worker".equals(type) || "shared_worker".equals(type) || "browser".equals(type)) {
            return type;
        }
        return "other";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initializedCallback(boolean success) {
        try {
            if (!success) {
                this.initializedPromise = false;
                boolean bl = false;
                return bl;
            }
            Target opener = this.opener();
            if (opener == null || opener.getPagePromise() == null || "page".equals(this.type())) {
                this.initializedPromise = true;
                boolean bl = true;
                return bl;
            }
            Page openerPage = opener.getPagePromise();
            if (openerPage.getListenerCount(Events.PAGE_POPUP.getName()) <= 0) {
                this.initializedPromise = true;
                boolean bl = true;
                return bl;
            }
            Page pupopPage = this.page();
            pupopPage.emit(Events.PAGE_POPUP.getName(), pupopPage);
            this.initializedPromise = true;
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.initializedCountDown != null) {
                this.initializedCountDown.countDown();
                this.initializedCountDown = null;
            }
        }
    }

    public boolean waitInitializedPromise() {
        if (this.initializedPromise == null) {
            this.initializedCountDown = new CountDownLatch(1);
            try {
                this.initializedCountDown.await(30000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Wait for InitializedPromise fail:", e);
            }
        }
        return this.initializedPromise;
    }

    public Target opener() {
        String openerId = this.targetInfo.getOpenerId();
        if (StringUtil.isEmpty(openerId)) {
            return null;
        }
        return this.browser().getTargets().get(openerId);
    }

    public String url() {
        return this.targetInfo.getUrl();
    }

    public Browser browser() {
        return this.browserContext.browser();
    }

    public Page getPagePromise() {
        return this.pagePromise;
    }

    public void setPagePromise(Page pagePromise) {
        this.pagePromise = pagePromise;
    }

    public Worker getWorkerPromise() {
        return this.workerPromise;
    }

    public void setWorkerPromise(Worker workerPromise) {
        this.workerPromise = workerPromise;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public TargetInfo getTargetInfo() {
        return this.targetInfo;
    }

    public void setTargetInfo(TargetInfo targetInfo) {
        this.targetInfo = targetInfo;
    }

    public BrowserContext browserContext() {
        return this.browserContext;
    }

    public void setBrowserContext(BrowserContext browserContext) {
        this.browserContext = browserContext;
    }

    public boolean isIgnoreHTTPSErrors() {
        return this.ignoreHTTPSErrors;
    }

    public void setIgnoreHTTPSErrors(boolean ignoreHTTPSErrors) {
        this.ignoreHTTPSErrors = ignoreHTTPSErrors;
    }

    public Viewport getDefaultViewport() {
        return this.viewport;
    }

    public void setDefaultViewport(Viewport viewport) {
        this.viewport = viewport;
    }

    public boolean getIsInitialized() {
        return this.isInitialized;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void targetInfoChanged(TargetInfo targetInfo) {
        this.targetInfo = targetInfo;
        if (!(this.isInitialized || "page".equals(this.targetInfo.getType()) && "".equals(this.targetInfo.getUrl()))) {
            this.isInitialized = true;
            this.initializedCallback(true);
        }
    }

    public boolean WaiforisClosedPromise() throws InterruptedException {
        return this.isClosedPromiseLatch.await(30000L, TimeUnit.MILLISECONDS);
    }
}

