/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaoding.open.client;

import com.alibaba.fastjson.JSON;
import io.github.gaoding.open.client.Client;
import io.github.gaoding.open.constant.BizCode;
import io.github.gaoding.open.model.Config;
import io.github.gaoding.open.model.HttpResponse;
import io.github.gaoding.open.model.Method;
import io.github.gaoding.open.model.Response;
import io.github.gaoding.open.spi.SignGenerator;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseClient
implements Client {
    protected final Config config;
    private final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, Runtime.getRuntime().availableProcessors() * 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "gd-http-client-executor-");
        }
    });
    private volatile SignGenerator signGenerator;

    public BaseClient(Config conf) {
        this.config = conf;
    }

    @Override
    public void close() throws Exception {
        this.EXECUTOR.shutdown();
    }

    protected abstract boolean check(String var1, Method var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateSign(String uri, Method method, String requestBody, String queryString, Long time) throws Exception {
        if (this.signGenerator == null) {
            BaseClient baseClient = this;
            synchronized (baseClient) {
                if (this.signGenerator == null) {
                    ServiceLoader<SignGenerator> shouts = ServiceLoader.load(SignGenerator.class);
                    SignGenerator signGen = null;
                    Iterator<SignGenerator> iterator = shouts.iterator();
                    while (iterator.hasNext()) {
                        SignGenerator shout;
                        signGen = shout = iterator.next();
                    }
                    if (signGen == null) {
                        throw new RuntimeException(BizCode.INIT_CLIENT_ERROR.getMessage());
                    }
                    this.signGenerator = signGen;
                }
            }
        }
        return this.signGenerator.generateSign(uri, method, requestBody, this.config.getAccessKey(), this.config.getSecretKey(), queryString, time);
    }

    protected abstract <T> Response<T> doExecute(String var1, Method var2, String var3, String var4, Map<String, String> var5, Long var6, String var7, Class<T> var8, Function<? super HttpResponse, ? extends Response<T>> var9);

    @Override
    public final <T> Response<T> execute(String uri, Method method, String requestBody, Map<String, String> queryParams, Map<String, String> headers, Class<T> clazz, boolean async, Function<? super HttpResponse, ? extends Response<T>> mapper) {
        if (!this.check(uri, method, requestBody)) {
            return Response.fail(BizCode.CLIENT_PARAMS_ERROR, 400);
        }
        Long time = System.currentTimeMillis() / 1000L;
        requestBody = StringUtils.isBlank((CharSequence)requestBody) || "{}".equals(requestBody) || "[]".equals(requestBody) ? "" : JSON.parse((String)requestBody).toString();
        StringBuilder body = new StringBuilder(requestBody);
        queryParams = queryParams == null ? Collections.emptyMap() : queryParams;
        String queryString = queryParams.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).reduce((a, b) -> a + "&" + b).orElse("");
        String sign = null;
        try {
            sign = this.generateSign(uri, method, body.toString(), queryString, time);
        }
        catch (Exception e) {
            return Response.fail(BizCode.GEN_SIGN_ERROR, 500);
        }
        String finalSign = sign;
        if (async) {
            AsyncResponse objectAsyncResponse = new AsyncResponse();
            this.EXECUTOR.execute(() -> {
                Response result = this.doExecute(uri, method, body.toString(), queryString, headers, time, finalSign, clazz, mapper);
                objectAsyncResponse.setData(result);
            });
            return objectAsyncResponse;
        }
        return this.doExecute(uri, method, body.toString(), queryString, headers, time, sign, clazz, mapper);
    }

    static class AsyncResponse<T>
    extends Response<T> {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        private Response<T> response;

        AsyncResponse() {
        }

        @Override
        public T getData() {
            return this.await() ? (T)this.response.getData() : null;
        }

        @Override
        public void setData(Response<T> data) {
            this.response = data;
            this.countDownLatch.countDown();
        }

        @Override
        public Integer getHttpStatus() {
            return this.await() ? this.response.getHttpStatus() : null;
        }

        private boolean await() {
            try {
                this.countDownLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        @Override
        public String getCode() {
            return this.await() ? this.response.getCode() : null;
        }

        public String toString() {
            return this.await() ? this.response.toString() : super.toString();
        }

        @Override
        public String getMessage() {
            return this.await() ? this.response.getMessage() : null;
        }
    }
}

