/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor.utils;

import io.github.linpeilie.processor.utils.FileUtils;
import io.github.linpeilie.processor.utils.FileWrapper;
import io.github.linpeilie.processor.utils.LineSeparator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;

public class FileWriter
extends FileWrapper {
    private static final long serialVersionUID = 1L;

    public static FileWriter create(File file, Charset charset) {
        return new FileWriter(file, charset);
    }

    public FileWriter(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public <T> File writeLines(Iterable<T> list, boolean isAppend) {
        return this.writeLines(list, null, isAppend);
    }

    public BufferedWriter getWriter(boolean isAppend) {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtils.touch(this.file), isAppend), this.charset));
        }
        catch (Exception e) {
            throw new UncheckedIOException(new IOException(e));
        }
    }

    public PrintWriter getPrintWriter(boolean isAppend) {
        return new PrintWriter(this.getWriter(isAppend));
    }

    public <T> File writeLines(Iterable<T> list, LineSeparator lineSeparator, boolean isAppend) {
        try (PrintWriter writer = this.getPrintWriter(isAppend);){
            boolean isFirst = true;
            for (T t : list) {
                if (null == t) continue;
                if (isFirst) {
                    isFirst = false;
                    if (isAppend && FileUtils.isNotEmpty(this.file)) {
                        this.printNewLine(writer, lineSeparator);
                    }
                } else {
                    this.printNewLine(writer, lineSeparator);
                }
                writer.print(t);
                writer.flush();
            }
        }
        return this.file;
    }

    private void printNewLine(PrintWriter writer, LineSeparator lineSeparator) {
        if (null == lineSeparator) {
            writer.println();
        } else {
            writer.print(lineSeparator.getValue());
        }
    }

    private void checkFile() {
        if (this.file == null) {
            throw new UncheckedIOException(new IOException("File to write content is null !"));
        }
        if (this.file.exists() && !this.file.isFile()) {
            throw new UncheckedIOException(new IOException("File [" + this.file.getAbsoluteFile() + "] is not a file !"));
        }
    }
}

