/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Converters;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.security.AbstractFamilyJwkFactory;
import io.jsonwebtoken.impl.security.ECCurve;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.UnsupportedKeyException;
import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.ECKey;
import java.util.Set;

abstract class AbstractEcJwkFactory<K extends Key & ECKey, J extends Jwk<K>>
extends AbstractFamilyJwkFactory<K, J> {
    protected static ECCurve getCurveByJwaId(String jwaCurveId) {
        ECCurve curve = ECCurve.findById(jwaCurveId);
        if (curve == null) {
            String msg = "Unrecognized JWA EC curve id '" + jwaCurveId + "'";
            throw new UnsupportedKeyException(msg);
        }
        return curve;
    }

    static String toOctetString(int fieldSize, BigInteger coordinate) {
        byte[] bytes = Converters.BIGINT_UBYTES.applyTo(coordinate);
        int mlen = (int)Math.ceil((double)fieldSize / 8.0);
        if (mlen > bytes.length) {
            byte[] m = new byte[mlen];
            System.arraycopy(bytes, 0, m, mlen - bytes.length, bytes.length);
            bytes = m;
        }
        return (String)Encoders.BASE64URL.encode((Object)bytes);
    }

    AbstractEcJwkFactory(Class<K> keyType, Set<Parameter<?>> params) {
        super("EC", keyType, params);
    }
}

