/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1StatefulSetCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="StatefulSetStatus represents the current state of a StatefulSet.")
public class V1StatefulSetStatus {
    public static final String SERIALIZED_NAME_AVAILABLE_REPLICAS = "availableReplicas";
    @SerializedName(value="availableReplicas")
    private Integer availableReplicas;
    public static final String SERIALIZED_NAME_COLLISION_COUNT = "collisionCount";
    @SerializedName(value="collisionCount")
    private Integer collisionCount;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1StatefulSetCondition> conditions = null;
    public static final String SERIALIZED_NAME_CURRENT_REPLICAS = "currentReplicas";
    @SerializedName(value="currentReplicas")
    private Integer currentReplicas;
    public static final String SERIALIZED_NAME_CURRENT_REVISION = "currentRevision";
    @SerializedName(value="currentRevision")
    private String currentRevision;
    public static final String SERIALIZED_NAME_OBSERVED_GENERATION = "observedGeneration";
    @SerializedName(value="observedGeneration")
    private Long observedGeneration;
    public static final String SERIALIZED_NAME_READY_REPLICAS = "readyReplicas";
    @SerializedName(value="readyReplicas")
    private Integer readyReplicas;
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    private Integer replicas;
    public static final String SERIALIZED_NAME_UPDATE_REVISION = "updateRevision";
    @SerializedName(value="updateRevision")
    private String updateRevision;
    public static final String SERIALIZED_NAME_UPDATED_REPLICAS = "updatedReplicas";
    @SerializedName(value="updatedReplicas")
    private Integer updatedReplicas;

    public V1StatefulSetStatus availableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of available pods (ready for at least minReadySeconds) targeted by this statefulset. This is an alpha field and requires enabling StatefulSetMinReadySeconds feature gate. Remove omitempty when graduating to beta")
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public void setAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    public V1StatefulSetStatus collisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.")
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public void setCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
    }

    public V1StatefulSetStatus conditions(List<V1StatefulSetCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1StatefulSetStatus addConditionsItem(V1StatefulSetCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1StatefulSetCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the latest available observations of a statefulset's current state.")
    public List<V1StatefulSetCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1StatefulSetCondition> conditions) {
        this.conditions = conditions;
    }

    public V1StatefulSetStatus currentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.")
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public void setCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
    }

    public V1StatefulSetStatus currentRevision(String currentRevision) {
        this.currentRevision = currentRevision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).")
    public String getCurrentRevision() {
        return this.currentRevision;
    }

    public void setCurrentRevision(String currentRevision) {
        this.currentRevision = currentRevision;
    }

    public V1StatefulSetStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1StatefulSetStatus readyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readyReplicas is the number of Pods created by the StatefulSet controller that have a Ready Condition.")
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public V1StatefulSetStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(required=true, value="replicas is the number of Pods created by the StatefulSet controller.")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1StatefulSetStatus updateRevision(String updateRevision) {
        this.updateRevision = updateRevision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)")
    public String getUpdateRevision() {
        return this.updateRevision;
    }

    public void setUpdateRevision(String updateRevision) {
        this.updateRevision = updateRevision;
    }

    public V1StatefulSetStatus updatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.")
    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    public void setUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StatefulSetStatus v1StatefulSetStatus = (V1StatefulSetStatus)o;
        return Objects.equals(this.availableReplicas, v1StatefulSetStatus.availableReplicas) && Objects.equals(this.collisionCount, v1StatefulSetStatus.collisionCount) && Objects.equals(this.conditions, v1StatefulSetStatus.conditions) && Objects.equals(this.currentReplicas, v1StatefulSetStatus.currentReplicas) && Objects.equals(this.currentRevision, v1StatefulSetStatus.currentRevision) && Objects.equals(this.observedGeneration, v1StatefulSetStatus.observedGeneration) && Objects.equals(this.readyReplicas, v1StatefulSetStatus.readyReplicas) && Objects.equals(this.replicas, v1StatefulSetStatus.replicas) && Objects.equals(this.updateRevision, v1StatefulSetStatus.updateRevision) && Objects.equals(this.updatedReplicas, v1StatefulSetStatus.updatedReplicas);
    }

    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.collisionCount, this.conditions, this.currentReplicas, this.currentRevision, this.observedGeneration, this.readyReplicas, this.replicas, this.updateRevision, this.updatedReplicas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1StatefulSetStatus {\n");
        sb.append("    availableReplicas: ").append(this.toIndentedString(this.availableReplicas)).append("\n");
        sb.append("    collisionCount: ").append(this.toIndentedString(this.collisionCount)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    currentReplicas: ").append(this.toIndentedString(this.currentReplicas)).append("\n");
        sb.append("    currentRevision: ").append(this.toIndentedString(this.currentRevision)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    readyReplicas: ").append(this.toIndentedString(this.readyReplicas)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    updateRevision: ").append(this.toIndentedString(this.updateRevision)).append("\n");
        sb.append("    updatedReplicas: ").append(this.toIndentedString(this.updatedReplicas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

