/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.event.legacy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.models.CoreV1Event;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.MutablePair;
import org.joda.time.DateTime;

public class EventLogger {
    private Cache<String, EventLog> eventCache;
    private Function<CoreV1Event, String> eventKeyFunc;

    public EventLogger(int lruCacheEntries, Function<CoreV1Event, String> eventKeyFunc) {
        this.eventCache = Caffeine.newBuilder().maximumSize((long)lruCacheEntries).build();
        this.eventKeyFunc = eventKeyFunc;
    }

    public MutablePair<CoreV1Event, V1Patch> observe(CoreV1Event event, String key) {
        DateTime now = DateTime.now();
        EventLog lastObserved = (EventLog)this.eventCache.getIfPresent((Object)key);
        V1Patch patch = null;
        if (lastObserved != null && lastObserved.count != null && lastObserved.count > 0) {
            event.setCount(Integer.valueOf(lastObserved.count + 1));
            event.setFirstTimestamp(lastObserved.firstTimestamp);
            event.getMetadata().setName(lastObserved.name);
            event.getMetadata().setResourceVersion(lastObserved.resourceVersion);
            patch = EventLogger.buildEventPatch(event.getCount(), event.getMessage(), now);
        }
        EventLog log = new EventLog();
        log.count = event.getCount();
        log.firstTimestamp = event.getFirstTimestamp();
        log.name = event.getMetadata().getName();
        log.resourceVersion = event.getMetadata().getResourceVersion();
        this.eventCache.put((Object)key, (Object)log);
        return new MutablePair((Object)event, (Object)patch);
    }

    public void updateState(CoreV1Event event) {
        String key = this.eventKeyFunc.apply(event);
        EventLog log = new EventLog();
        log.count = event.getCount();
        log.firstTimestamp = event.getFirstTimestamp();
        log.name = event.getMetadata().getName();
        log.resourceVersion = event.getMetadata().getResourceVersion();
        this.eventCache.put((Object)key, (Object)log);
    }

    static V1Patch buildEventPatch(int count, String message, DateTime now) {
        return new V1Patch(String.format("{\"message\":\"%s\",\"count\":%d,\"lastTimestamp\":%s}", message, count, Configuration.getDefaultApiClient().getJSON().serialize((Object)now)));
    }

    private static class EventLog {
        private Integer count;
        private DateTime firstTimestamp;
        private String name;
        private String resourceVersion;

        private EventLog() {
        }
    }
}

