/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml.ranker;

import com.alibaba.fastjson.JSONObject;
import io.milvus.exception.ParamException;
import io.milvus.param.dml.ranker.BaseRanker;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class RRFRanker
extends BaseRanker {
    private final Integer k;

    private RRFRanker(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.k = builder.k;
    }

    @Override
    public Map<String, String> getProperties() {
        JSONObject params = new JSONObject();
        params.put("k", (Object)this.k);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("strategy", "rrf");
        props.put("params", params.toString());
        return props;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getK() {
        return this.k;
    }

    public String toString() {
        return "RRFRanker(k=" + this.getK() + ")";
    }

    public static class Builder {
        private Integer k = 60;

        private Builder() {
        }

        public Builder withK(@NonNull Integer k) {
            if (k == null) {
                throw new NullPointerException("k is marked non-null but is null");
            }
            this.k = k;
            return this;
        }

        public RRFRanker build() throws ParamException {
            if (this.k < 0) {
                throw new ParamException("K value cannot be negative");
            }
            return new RRFRanker(this);
        }
    }
}

