/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.highlevel.dml;

import com.google.common.collect.Lists;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class SearchSimpleParam {
    private final String collectionName;
    private final List<?> vectors;
    private final List<String> outputFields;
    private final String filter;
    private final Long offset;
    private final int limit;
    private final Map<String, Object> params;
    private final ConsistencyLevelEnum consistencyLevel;

    private SearchSimpleParam(@NotNull Builder builder) {
        this.collectionName = builder.collectionName;
        this.vectors = builder.vectors;
        this.outputFields = builder.outputFields;
        this.filter = builder.filter;
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.params = builder.params;
        this.consistencyLevel = builder.consistencyLevel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<?> getVectors() {
        return this.vectors;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public String getFilter() {
        return this.filter;
    }

    public Long getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public ConsistencyLevelEnum getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public String toString() {
        return "SearchSimpleParam(collectionName=" + this.getCollectionName() + ", vectors=" + this.getVectors() + ", outputFields=" + this.getOutputFields() + ", filter=" + this.getFilter() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", params=" + this.getParams() + ", consistencyLevel=" + (Object)((Object)this.getConsistencyLevel()) + ")";
    }

    public static class Builder {
        private String collectionName;
        private List<?> vectors;
        private final List<String> outputFields = Lists.newArrayList();
        private String filter = "";
        private Long offset = 0L;
        private int limit = 10;
        private ConsistencyLevelEnum consistencyLevel = null;
        private final Map<String, Object> params = new HashMap<String, Object>();

        Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withFilter(@NonNull String filter) {
            if (filter == null) {
                throw new NullPointerException("filter is marked non-null but is null");
            }
            this.filter = filter;
            return this;
        }

        public Builder withOutputFields(@NonNull List<String> outputFields) {
            if (outputFields == null) {
                throw new NullPointerException("outputFields is marked non-null but is null");
            }
            this.outputFields.addAll(outputFields);
            return this;
        }

        public Builder withVectors(@NonNull List<?> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            this.vectors = vectors;
            return this;
        }

        public Builder withOffset(@NonNull Long offset) {
            if (offset == null) {
                throw new NullPointerException("offset is marked non-null but is null");
            }
            this.offset = offset;
            return this;
        }

        public Builder withLimit(@NonNull Long limit) {
            if (limit == null) {
                throw new NullPointerException("limit is marked non-null but is null");
            }
            this.limit = Math.toIntExact(limit);
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevelEnum consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public SearchSimpleParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (CollectionUtils.isEmpty(this.vectors)) {
                throw new ParamException("vector cannot be empty");
            }
            if (this.offset < 0L) {
                throw new ParamException("The offset value cannot be less than 0");
            }
            if (this.limit < 0) {
                throw new ParamException("The limit value cannot be less than 0");
            }
            this.params.put("offset", this.offset);
            return new SearchSimpleParam(this);
        }
    }
}

