/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.Cookie;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.http.HttpInfos;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;

public interface HttpServerResponse
extends NettyOutbound,
HttpInfos {
    public HttpServerResponse addCookie(Cookie var1);

    public HttpServerResponse addHeader(CharSequence var1, CharSequence var2);

    public HttpServerResponse chunkedTransfer(boolean var1);

    @Override
    public HttpServerResponse withConnection(Consumer<? super Connection> var1);

    public HttpServerResponse compression(boolean var1);

    public boolean hasSentHeaders();

    public HttpServerResponse header(CharSequence var1, CharSequence var2);

    public HttpServerResponse headers(HttpHeaders var1);

    public HttpServerResponse keepAlive(boolean var1);

    public HttpHeaders responseHeaders();

    public Mono<Void> send();

    public NettyOutbound sendHeaders();

    public Mono<Void> sendNotFound();

    public Mono<Void> sendRedirect(String var1);

    default public Mono<Void> sendWebsocket(BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        return this.sendWebsocket(null, websocketHandler);
    }

    default public Mono<Void> sendWebsocket(@Nullable String protocols, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        return this.sendWebsocket(protocols, 65536, websocketHandler);
    }

    public Mono<Void> sendWebsocket(@Nullable String var1, int var2, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> var3);

    public HttpServerResponse sse();

    public HttpResponseStatus status();

    public HttpServerResponse status(HttpResponseStatus var1);

    default public HttpServerResponse status(int status) {
        return this.status(HttpResponseStatus.valueOf((int)status));
    }
}

