/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall;

import io.rainfall.AssertionEvaluator;
import io.rainfall.Configuration;
import io.rainfall.Operation;
import io.rainfall.Scenario;
import io.rainfall.TestException;
import io.rainfall.statistics.StatisticsHolder;
import io.rainfall.utils.ConcurrentPseudoRandom;
import io.rainfall.utils.RangeMap;
import java.util.List;
import java.util.Map;

public abstract class Execution {
    protected ConcurrentPseudoRandom weightRnd = new ConcurrentPseudoRandom();

    public void markExecutionState(Scenario scenario, ExecutionState state) {
        for (RangeMap<Operation> opMap : scenario.getOperations()) {
            for (Operation op : opMap.getAll()) {
                op.markExecutionState(state);
            }
        }
    }

    public abstract <E extends Enum<E>> void execute(StatisticsHolder<E> var1, Scenario var2, Map<Class<? extends Configuration>, Configuration> var3, List<AssertionEvaluator> var4) throws TestException;

    public abstract String getDescription();

    public static enum ExecutionState {
        UNKNOWN,
        BEGINNING,
        ENDING;

    }
}

