/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall;

import io.rainfall.TestException;
import io.rainfall.configuration.DistributedConfig;
import io.rainfall.utils.RainfallServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.CyclicBarrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RainfallMaster {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DistributedConfig distributedConfig;
    private RainfallServer rainfallServer = null;

    public RainfallMaster(DistributedConfig distributedConfig) {
        this.distributedConfig = distributedConfig;
    }

    public static RainfallMaster master(DistributedConfig distributedConfig) {
        return new RainfallMaster(distributedConfig);
    }

    public RainfallMaster start() throws TestException {
        ServerSocket serverSocket;
        try {
            this.logger.debug("[Rainfall server] Check if configuration server hostname is current host.");
            if (!Arrays.toString(InetAddress.getByName("localhost").getAddress()).equalsIgnoreCase(Arrays.toString(this.distributedConfig.getMasterAddress().getAddress().getAddress()))) {
                this.logger.debug("[Rainfall server] Current host is NOT the server host, so we return to start the client");
                return this;
            }
        }
        catch (UnknownHostException e) {
            throw new TestException("Can not run multi-clients test.", e);
        }
        try {
            serverSocket = new ServerSocket(this.distributedConfig.getMasterAddress().getPort());
        }
        catch (IOException e) {
            this.logger.debug("[Rainfall server] already started");
            return this;
        }
        this.logger.debug("[Rainfall server] Current host is the server host, so we start the Rainfall server");
        this.rainfallServer = new RainfallServer(this.distributedConfig, serverSocket);
        this.rainfallServer.start();
        return this;
    }

    public void stop() throws TestException {
        TestException testException;
        if (this.rainfallServer != null) {
            try {
                this.rainfallServer.shutdown();
                this.rainfallServer.join();
            }
            catch (InterruptedException e) {
                throw new TestException("Rainfall cluster client interrupted", e);
            }
        }
        if (this.rainfallServer != null && (testException = this.rainfallServer.getTestException().get()) != null) {
            throw testException;
        }
    }

    public CyclicBarrier getBarrier(String barrierName, int parties) {
        throw new UnsupportedOperationException("clustered cyclic barrier is not implemented");
    }
}

