/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall;

import io.rainfall.Assertion;
import io.rainfall.AssertionEvaluator;
import io.rainfall.Configuration;
import io.rainfall.Execution;
import io.rainfall.Operation;
import io.rainfall.Scenario;
import io.rainfall.SyntaxException;
import io.rainfall.TestException;
import io.rainfall.configuration.ConcurrencyConfig;
import io.rainfall.configuration.DistributedConfig;
import io.rainfall.configuration.ReportingConfig;
import io.rainfall.statistics.InitStatisticsHolder;
import io.rainfall.statistics.RuntimeStatisticsHolder;
import io.rainfall.statistics.StatisticsPeekHolder;
import io.rainfall.statistics.StatisticsThread;
import io.rainfall.utils.RainfallClient;
import io.rainfall.utils.RangeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioRun<E extends Enum<E>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Scenario scenario;
    private Map<Class<? extends Configuration>, Configuration> configurations = new ConcurrentHashMap<Class<? extends Configuration>, Configuration>();
    private List<AssertionEvaluator> assertions = new ArrayList<AssertionEvaluator>();
    private Execution warmup = null;
    private List<Execution> executions = null;
    private RuntimeStatisticsHolder<E> statisticsHolder;

    public ScenarioRun(Scenario scenario) {
        this.scenario = scenario;
        this.initDefaultConfigurations();
    }

    private void initDefaultConfigurations() {
        this.configurations.put(ConcurrencyConfig.class, new ConcurrencyConfig());
    }

    public ScenarioRun warmup(Execution execution) throws SyntaxException {
        if (this.warmup != null) {
            throw new SyntaxException("Warmup is already defined.");
        }
        this.warmup = execution;
        return this;
    }

    public ScenarioRun executed(Execution ... executions) throws SyntaxException {
        if (this.executions != null) {
            throw new SyntaxException("Executions are already defined.");
        }
        this.executions = Arrays.asList(executions);
        return this;
    }

    public ScenarioRun config(Configuration ... configs) {
        for (Configuration config : configs) {
            this.configurations.put(config.getClass(), config);
        }
        return this;
    }

    public ScenarioRun assertion(Assertion actual, Assertion expected) {
        this.assertions.add(new AssertionEvaluator(actual, expected));
        return this;
    }

    public StatisticsPeekHolder<E> start() {
        DistributedConfig distributedConfig = (DistributedConfig)this.configurations.get(DistributedConfig.class);
        if (distributedConfig != null) {
            this.startCluster(distributedConfig);
        }
        long start = System.currentTimeMillis();
        ReportingConfig reportingConfig = (ReportingConfig)this.configurations.get(ReportingConfig.class);
        RuntimeStatisticsHolder blankStatisticsHolder = new RuntimeStatisticsHolder(reportingConfig.getResults(), reportingConfig.getResultsReported(), reportingConfig.getStatisticsCollectors());
        this.initStatistics(blankStatisticsHolder);
        try {
            if (this.warmup != null) {
                System.out.println("Executing warmup phase, please wait.");
                this.warmup.execute(blankStatisticsHolder, this.scenario, this.configurations, this.assertions);
            }
        }
        catch (TestException e) {
            throw new RuntimeException(e);
        }
        this.statisticsHolder = new RuntimeStatisticsHolder(reportingConfig.getResults(), reportingConfig.getResultsReported(), reportingConfig.getStatisticsCollectors());
        this.initStatistics(this.statisticsHolder);
        Timer timer = new Timer();
        StatisticsThread<E> stats = new StatisticsThread<E>(this.statisticsHolder, reportingConfig, this.getDescription(), reportingConfig.getStatisticsCollectors());
        TimeUnit reportIntervalUnit = reportingConfig.getReportTimeUnit();
        long reportIntervalMillis = reportIntervalUnit.toMillis(reportingConfig.getReportInterval());
        timer.scheduleAtFixedRate(stats, reportIntervalMillis, reportIntervalMillis);
        try {
            for (Execution execution : this.executions) {
                execution.execute(this.statisticsHolder, this.scenario, this.configurations, this.assertions);
            }
        }
        catch (TestException e) {
            throw new RuntimeException(e);
        }
        StatisticsPeekHolder<E> peek = stats.stop();
        long end = System.currentTimeMillis();
        timer.purge();
        timer.cancel();
        if (distributedConfig != null) {
            try {
                this.stopCluster(distributedConfig);
            }
            catch (TestException e) {
                throw new RuntimeException(e);
            }
        }
        return peek;
    }

    private void startCluster(DistributedConfig distributedConfig) {
        try {
            RainfallClient currentClient = new RainfallClient(distributedConfig.getMasterAddress());
            distributedConfig.setCurrentClient(currentClient);
            currentClient.start();
            while (!currentClient.canStart()) {
                Thread.sleep(250L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void stopCluster(DistributedConfig distributedConfig) throws TestException {
        RainfallClient currentClient = distributedConfig.getCurrentClient();
        currentClient.sendReport();
        try {
            currentClient.join();
            TestException testException = currentClient.getTestException().get();
            if (testException != null) {
                throw testException;
            }
        }
        catch (InterruptedException e) {
            throw new TestException("Rainfall cluster client interrupted", e);
        }
    }

    private List<String> getDescription() {
        ArrayList<String> description = new ArrayList<String>();
        description.addAll(this.scenario.getDescription());
        description.add("");
        if (this.warmup != null) {
            description.add("Warmup phase " + this.warmup.getDescription());
        }
        description.add("Execution of the scenario : ");
        int step = 1;
        for (Execution execution : this.executions) {
            description.add(step + ") " + execution.getDescription());
        }
        description.add("");
        for (Configuration configuration : this.configurations.values()) {
            List<String> descs = configuration.getDescription();
            for (String desc : descs) {
                description.add(desc);
            }
        }
        return description;
    }

    private void initStatistics(RuntimeStatisticsHolder<E> statisticsHolder) {
        try {
            List<RangeMap<Operation>> operations = this.scenario.getOperations();
            for (RangeMap<Operation> operation : operations) {
                Collection<Operation> allOperations = operation.getAll();
                for (Operation allOperation : allOperations) {
                    allOperation.exec(new InitStatisticsHolder<E>(statisticsHolder), this.configurations, this.assertions);
                }
            }
        }
        catch (TestException e) {
            throw new RuntimeException(e);
        }
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public Configuration getConfiguration(Class configurationClass) {
        return this.configurations.get(configurationClass);
    }

    public List<AssertionEvaluator> getAssertions() {
        return this.assertions;
    }
}

